/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.geotools.test.TestData;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryTypeConverterTest
extends TestCase {
    Set<ConverterFactory> factories = null;
    List<String> tests = new ArrayList<String>();
    WKTReader wktReader = new WKTReader();

    protected Converter getConverter(Geometry source, Class<?> target) {
        GeometryTypeConverterTest.assertNotNull((String)"Cannot get ConverterFactory for Geometry -> Geometry conversion", this.factories);
        if (this.factories == null) {
            return null;
        }
        for (ConverterFactory factory : this.factories) {
            Converter candidate = factory.createConverter(source.getClass(), target, null);
            if (candidate == null) continue;
            return candidate;
        }
        GeometryTypeConverterTest.fail((String)("Cannot get ConverterFactory for " + source.getClass().getName() + " -> " + target.getClass().getName() + " conversion"));
        return null;
    }

    public void setUp() throws Exception {
        this.factories = Converters.getConverterFactories(Geometry.class, Geometry.class);
        File testData = TestData.file((Object)((Object)this), (String)"converter/tests.txt");
        GeometryTypeConverterTest.assertNotNull((String)"Cannot find test file (converter.txt)", (Object)testData);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(testData));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.tests.add(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testData() throws Exception {
        for (String test : this.tests) {
            String[] parts = test.split(":");
            GeometryTypeConverterTest.assertEquals((String)"Test rows should have the form \"source:target:expected:description\"", (int)4, (int)parts.length);
            Geometry source = this.wktReader.read(parts[0]);
            Class<?> target = Class.forName("com.vividsolutions.jts.geom." + parts[1]);
            String expected = parts[2];
            Geometry converted = this.convert(source, target);
            GeometryTypeConverterTest.assertEquals((String)expected, (String)converted.toText());
        }
    }

    private Geometry convert(Geometry source, Class<?> target) throws Exception {
        Converter converter = this.getConverter(source, target);
        Object dest = converter.convert((Object)source, target);
        GeometryTypeConverterTest.assertNotNull((String)("Cannot convert " + source.toText() + " to " + target.getName()), (Object)dest);
        GeometryTypeConverterTest.assertTrue((String)"Converted object is not a Geometry", (boolean)(dest instanceof Geometry));
        return (Geometry)dest;
    }
}

