/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements CharSequence,
Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -6793384507333713770L;
    private static final Pattern PATTERN = Pattern.compile("(\\.|\\-)");
    private final String version;
    private transient String[] components;
    private transient Comparable<?>[] parsed;
    private transient int hashCode;

    public Version(String version) {
        this.version = version.trim();
    }

    public Comparable<?> getMajor() {
        return this.getComponent(0);
    }

    public Comparable<?> getMinor() {
        return this.getComponent(1);
    }

    public Comparable<?> getRevision() {
        return this.getComponent(2);
    }

    public synchronized Comparable<?> getComponent(int index) {
        if (this.parsed == null) {
            if (this.components == null) {
                this.components = PATTERN.split(this.version);
            }
            this.parsed = new Comparable[this.components.length];
        }
        if (index >= this.parsed.length) {
            return null;
        }
        Object candidate = this.parsed[index];
        if (candidate == null) {
            String value = this.components[index].trim();
            try {
                candidate = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                candidate = value;
            }
            this.parsed[index] = candidate;
        }
        return candidate;
    }

    private static int getTypeRank(Object value) {
        if (value instanceof CharSequence) {
            return 0;
        }
        if (value instanceof Number) {
            return 1;
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public int compareTo(Version other, int limit) {
        for (int i = 0; i < limit; ++i) {
            Comparable<?> v1 = this.getComponent(i);
            Comparable<?> v2 = other.getComponent(i);
            if (v1 == null) {
                return v2 == null ? 0 : -1;
            }
            if (v2 == null) {
                return 1;
            }
            int dr = Version.getTypeRank(v1) - Version.getTypeRank(v2);
            if (dr != 0) {
                return dr;
            }
            int c = v1.compareTo(v2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public int compareTo(Version other) {
        return this.compareTo(other, Integer.MAX_VALUE);
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            return this.compareTo((Version)other) == 0;
        }
        return false;
    }

    @Override
    public int length() {
        return this.version.length();
    }

    @Override
    public char charAt(int index) {
        return this.version.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.version.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            Comparable<?> component;
            int code = -1849991018;
            int index = 0;
            while ((component = this.getComponent(index)) != null) {
                code = code * 37 + component.hashCode();
                ++index;
            }
            this.hashCode = code;
        }
        return this.hashCode;
    }
}

