/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.datasource.DataSourceUtil;
import org.geotools.data.oracle.OracleDataStore;
import org.geotools.util.logging.Logging;

public class OracleOCIDataStoreFactory
implements DataStoreFactorySpi {
    private static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.oracle");
    static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "This must be 'oracle'.", true, (Object)"oracle");
    static final DataAccessFactory.Param ALIAS = new DataAccessFactory.Param("alias", String.class, "The alias to the oracle server, as defined in the tnsnames.ora file", true);
    static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", String.class, "The port oracle is running on. (Default is 1521)", true, (Object)"1521");
    static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "The user name to log in with.", true);
    static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, "The password.", true);
    static final DataAccessFactory.Param INSTANCE = new DataAccessFactory.Param("instance", String.class, "The name of the Oracle instance to connect to.", true);
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of open connections", false, (Object)new Integer(10));
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled connection", false, (Object)new Integer(4));
    public static final DataAccessFactory.Param VALIDATECONN = new DataAccessFactory.Param("validate connections", Boolean.class, "check connection is alive before using it", false, (Object)Boolean.FALSE);
    static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "The schema name to narrow down the exposed tables (must be upper case).", false){

        public Object lookUp(Map map) throws IOException {
            if (!map.containsKey(this.key)) {
                if (this.required) {
                    throw new IOException("Parameter " + this.key + " is required:" + this.description);
                }
                return null;
            }
            Object value = map.get(this.key);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String text = (String)value;
                if (text == null) {
                    return null;
                }
                if (text.equals(text.toUpperCase())) {
                    return text;
                }
                throw new IOException("Schema must be supplied in uppercase");
            }
            throw new IOException("String required for parameter " + this.key + ": not " + value.getClass().getName());
        }
    };
    static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "The namespace to give the DataStore", false);

    public boolean canProcess(Map params) {
        return params.containsKey("dbtype") && params.get("dbtype").equals("oracle") && params.containsKey("alias") && params.containsKey("user") && params.containsKey("passwd");
    }

    public DataStore createDataStore(Map params) throws IOException {
        String alias = (String)ALIAS.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        String schema = (String)SCHEMA.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        String dbtype = (String)DBTYPE.lookUp(params);
        Integer maxConn = (Integer)MAXCONN.lookUp(params);
        Integer minConn = (Integer)MINCONN.lookUp(params);
        Boolean validateConn = (Boolean)VALIDATECONN.lookUp(params);
        if (!"oracle".equals(dbtype)) {
            throw new IOException("Parameter 'dbtype' must be oracle");
        }
        if (!this.canProcess(params)) {
            throw new IOException("Cannot connect using provided parameters");
        }
        boolean validate = validateConn != null && validateConn != false;
        int maxActive = maxConn != null ? maxConn : 10;
        int maxIdle = minConn != null ? minConn : 4;
        DataSource source = OracleOCIDataStoreFactory.getDefaultDataSource(alias, user, passwd, maxActive, maxIdle, validate);
        return new OracleDataStore(source, namespace, schema, new HashMap());
    }

    public static DataSource getDefaultDataSource(String alias, String user, String passwd, int maxActive, int minIdle, boolean validate) throws DataSourceException {
        String dbUrl = "jdbc:oracle:oci:@" + alias;
        return DataSourceUtil.buildDefaultDataSource((String)dbUrl, (String)JDBC_DRIVER, (String)user, (String)passwd, (int)maxActive, (int)minIdle, (String)(validate ? "select sysdate from dual" : null), (boolean)false, (int)0);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Oracle cannot create a new Database");
    }

    public String getDisplayName() {
        return "Oracle (OCI)";
    }

    public String getDescription() {
        return "Oracle Spatial w/ OCI (thick) connection";
    }

    public boolean isAvailable() {
        try {
            Class.forName(JDBC_DRIVER);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBTYPE, ALIAS, USER, PASSWD, SCHEMA, NAMESPACE};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

