/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;

final class SqlStatementEncoder {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.oracle");
    private SQLEncoder whereEncoder;
    private String fidColumn;
    private String tableName;
    protected static final TypeMapping TYPE_MAPPINGS = new TypeMapping();

    SqlStatementEncoder(SQLEncoder whereEncoder, String tablename, String fidColumn) {
        this.whereEncoder = whereEncoder;
        this.tableName = tablename;
        this.fidColumn = fidColumn;
    }

    String makeCreateTableSQL(SimpleFeatureType schema) {
        StringBuffer sql = new StringBuffer("CREATE TABLE ");
        sql.append(this.tableName);
        sql.append("(");
        sql.append(this.fidColumn);
        sql.append(" NUMBER,");
        AttributeDescriptor[] attributeTypes = schema.getAttributeDescriptors().toArray(new AttributeDescriptor[schema.getAttributeDescriptors().size()]);
        for (int i = 0; i < attributeTypes.length; ++i) {
            sql.append(attributeTypes[i].getLocalName());
            sql.append(" ");
            sql.append(this.makeType(attributeTypes[i].getType().getBinding()));
            if (i < attributeTypes.length - 1) {
                sql.append(",");
                continue;
            }
            sql.append(")");
        }
        return sql.toString();
    }

    public String makeCreateFidIndex() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE UNIQUE INDEX ");
        sql.append(this.tableName);
        sql.append("_index ON (");
        sql.append(this.fidColumn);
        sql.append(" )");
        return sql.toString();
    }

    public String makeCreateGeomIndex(SimpleFeatureType schema) {
        StringBuffer sql = new StringBuffer();
        String defaultGeometry = schema.getGeometryDescriptor().getLocalName();
        sql.append("CREATE INDEX ");
        sql.append(this.tableName);
        sql.append("_sidx ON ");
        sql.append(this.tableName);
        sql.append("(");
        sql.append(defaultGeometry);
        sql.append(") INDEXTYPE IS mdsys.spatial_index");
        return sql.toString();
    }

    String makeType(Class type) {
        return TYPE_MAPPINGS.getName(type);
    }

    String makeInsertSQL(SimpleFeatureType featureType) {
        int i;
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(this.tableName);
        sql.append("(");
        sql.append(this.fidColumn);
        sql.append(",");
        AttributeDescriptor[] attributeTypes = featureType.getAttributeDescriptors().toArray(new AttributeDescriptor[featureType.getAttributeDescriptors().size()]);
        for (i = 0; i < attributeTypes.length; ++i) {
            sql.append(attributeTypes[i].getLocalName());
            if (i < attributeTypes.length - 1) {
                sql.append(",");
                continue;
            }
            sql.append(")");
        }
        sql.append(" VALUES (?,");
        for (i = 0; i < attributeTypes.length; ++i) {
            sql.append("?");
            if (i < attributeTypes.length - 1) {
                sql.append(",");
                continue;
            }
            sql.append(")");
        }
        return sql.toString();
    }

    String makeSelectSQL(AttributeDescriptor[] attrTypes, org.geotools.filter.Filter filter, int maxFeatures, boolean useMax) throws SQLEncoderException {
        LOGGER.finer("Creating sql for Query: mf=" + maxFeatures + " filter=" + filter + " useMax=" + useMax);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        sqlBuffer.append(this.fidColumn);
        for (int i = 0; i < attrTypes.length; ++i) {
            sqlBuffer.append(", ");
            sqlBuffer.append(attrTypes[i].getLocalName());
        }
        sqlBuffer.append(" FROM ");
        sqlBuffer.append(this.tableName);
        if (filter != null && filter != org.geotools.filter.Filter.NONE) {
            String where = this.whereEncoder.encode((Filter)filter);
            sqlBuffer.append(" ");
            sqlBuffer.append(where);
            if (useMax && maxFeatures > 0) {
                sqlBuffer.append(" and ROWNUM <= ");
                sqlBuffer.append(maxFeatures);
            }
        } else if (useMax && maxFeatures > 0) {
            sqlBuffer.append(" WHERE ROWNUM <= ");
            sqlBuffer.append(maxFeatures);
        }
        String sqlStmt = sqlBuffer.toString();
        LOGGER.finer("sqlString = " + sqlStmt);
        return sqlStmt;
    }

    String makeModifyTemplate(AttributeDescriptor[] attributeTypes) {
        StringBuffer buffer = new StringBuffer("UPDATE ");
        buffer.append(this.tableName);
        buffer.append(" SET ");
        for (int i = 0; i < attributeTypes.length; ++i) {
            buffer.append(attributeTypes[i].getLocalName());
            buffer.append(" = ? ");
            if (i < attributeTypes.length - 1) {
                buffer.append(", ");
                continue;
            }
            buffer.append(" ");
        }
        return buffer.toString();
    }

    String makeModifyTemplate(AttributeDescriptor[] attributeTypes, org.geotools.filter.Filter filter) throws SQLEncoderException {
        String whereClause = this.whereEncoder.encode((Filter)filter);
        return this.makeModifyTemplate(attributeTypes) + " " + whereClause;
    }

    String makeDeleteSQL(org.geotools.filter.Filter filter) throws SQLEncoderException {
        return "DELETE FROM " + this.tableName + " " + this.whereEncoder.encode((Filter)filter);
    }

    public String makeAddGeomMetadata(SimpleFeatureType featureType, Envelope bounds, int srid) {
        StringBuffer sql = new StringBuffer();
        String defaultGeometry = featureType.getGeometryDescriptor().getLocalName();
        sql.append("INSERT INTO user_sdo_geom_metadata");
        sql.append("  (TABLE_NAME, COLUMN_NAME,DIMINFO,SRID)");
        sql.append("VALUES (");
        sql.append("   '" + this.tableName + "',");
        sql.append("   '" + defaultGeometry + "',");
        sql.append("   MDSYS.SDO_DIM_ARRAY(");
        sql.append("       MDSYS.SDO_DIM_ELEMENT('X', " + bounds.getMinX() + "," + bounds.getMaxX() + ", 0.005),");
        sql.append("       MDSYS.SDO_DIM_ELEMENT('Y', " + bounds.getMinY() + "," + bounds.getMaxY() + ", 0.005)");
        sql.append("   ),");
        sql.append("   " + (srid == -1 ? "NULL" : String.valueOf(srid)));
        sql.append(")");
        return sql.toString();
    }

    static {
        TYPE_MAPPINGS.put("CHAR", String.class);
        TYPE_MAPPINGS.put("LONGVARCHAR", String.class);
        TYPE_MAPPINGS.put("VARCHAR", String.class);
        TYPE_MAPPINGS.put("BIT", Boolean.class);
        TYPE_MAPPINGS.put("BOOLEAN", Boolean.class);
        TYPE_MAPPINGS.put("TINYINT", Short.class);
        TYPE_MAPPINGS.put("SMALLINT", Short.class);
        TYPE_MAPPINGS.put("INTEGER", Integer.class);
        TYPE_MAPPINGS.put("BIGINT", Long.class);
        TYPE_MAPPINGS.put("REAL", Float.class);
        TYPE_MAPPINGS.put("FLOAT", Double.class);
        TYPE_MAPPINGS.put("DOUBLE", Double.class);
        TYPE_MAPPINGS.put("DECIMAL", BigDecimal.class);
        TYPE_MAPPINGS.put("NUMERIC", BigDecimal.class);
        TYPE_MAPPINGS.put("DATE", Date.class);
        TYPE_MAPPINGS.put("TIME", Time.class);
        TYPE_MAPPINGS.put("TIMESTAMP", Timestamp.class);
        TYPE_MAPPINGS.put("MDSYS.SDO_GEOMETRY", Geometry.class);
    }

    static class TypeMapping {
        Map intMap = new HashMap();
        Map sqlMap = new HashMap();
        Map typeMap = new HashMap();

        TypeMapping() {
        }

        public void put(String name, Class javaType) {
            if (name.indexOf(".") == -1 && name.indexOf("_") == -1) {
                try {
                    Field field = Types.class.getField(name);
                    Integer integer = (Integer)field.get(null);
                    this.intMap.put(integer, javaType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.sqlMap.put(name, javaType);
            this.typeMap.put(javaType, name);
        }

        public String getName(Class type) {
            for (Class t : this.typeMap.keySet()) {
                if (t != type) continue;
                return (String)this.typeMap.get(t);
            }
            for (Class t : this.typeMap.keySet()) {
                if (!t.isAssignableFrom(type)) continue;
                return (String)this.typeMap.get(t);
            }
            return "NIL";
        }
    }
}

