/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoder;
import org.geotools.util.logging.Logging;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class SQLEncoderPostgis
extends SQLEncoder
implements FilterVisitor {
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private static WKTWriter wkt = new WKTWriter();
    private int srid;
    private String defaultGeom;
    protected boolean looseBbox = false;
    protected boolean supportsGEOS = false;

    public SQLEncoderPostgis() {
        this.capabilities = this.createFilterCapabilities();
        this.setSqlNameEscape("\"");
    }

    public SQLEncoderPostgis(boolean looseBbox) {
        this();
        this.looseBbox = looseBbox;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addType(0x40000000L);
        capabilities.addType(IncludeFilter.class);
        capabilities.addType(Integer.MIN_VALUE);
        capabilities.addType(ExcludeFilter.class);
        capabilities.addType(0x400000L);
        capabilities.addType(Id.class);
        capabilities.addType(8192L);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(4096L);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(0x3800000L);
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addType(16384L);
        capabilities.addType(Add.class);
        capabilities.addType(Multiply.class);
        capabilities.addType(Subtract.class);
        capabilities.addType(Divide.class);
        capabilities.addType(0x3F0000L);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(1L);
        capabilities.addType(BBOX.class);
        capabilities.addType(2048L);
        capabilities.addType(PropertyIsLike.class);
        if (this.supportsGEOS) {
            capabilities.addType(128L);
            capabilities.addType(Contains.class);
            capabilities.addType(32L);
            capabilities.addType(Crosses.class);
            capabilities.addType(4L);
            capabilities.addType(Disjoint.class);
            capabilities.addType(2L);
            capabilities.addType(Equals.class);
            capabilities.addType(8L);
            capabilities.addType(Intersects.class);
            capabilities.addType(256L);
            capabilities.addType(Overlaps.class);
            capabilities.addType(16L);
            capabilities.addType(Touches.class);
            capabilities.addType(64L);
            capabilities.addType(Within.class);
        }
        return capabilities;
    }

    public SQLEncoderPostgis(int srid) {
        this(true);
        this.srid = srid;
    }

    public void setLooseBbox(boolean isLooseBbox) {
        this.looseBbox = isLooseBbox;
    }

    public boolean isLooseBbox() {
        return this.looseBbox;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public void setDefaultGeometry(String name) {
        this.defaultGeom = name;
    }

    public void setSupportsGEOS(boolean supports) {
        boolean oldValue = this.supportsGEOS;
        this.supportsGEOS = supports;
        if (this.capabilities == null || supports != oldValue) {
            this.capabilities = this.createFilterCapabilities();
        }
    }

    public boolean getSupportsGEOS() {
        return this.supportsGEOS;
    }

    private void encodeGeomFilter(GeometryFilter filter, String function, String comparison, boolean useIndex) {
        DefaultExpression left = (DefaultExpression)filter.getLeftGeometry();
        DefaultExpression right = (DefaultExpression)filter.getRightGeometry();
        try {
            if (useIndex) {
                this.encodeExpression(left);
                this.out.write(" && ");
                this.encodeExpression(right);
            }
            if (filter.getFilterType() != 4 || !this.looseBbox) {
                if (useIndex) {
                    this.out.write(" AND ");
                }
                this.out.write(String.valueOf(function) + "(");
                this.encodeExpression(left);
                this.out.write(", ");
                this.encodeExpression(right);
                this.out.write(")" + comparison);
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    private void encodeExpression(DefaultExpression expr) throws IOException {
        if (expr == null) {
            this.out.write("\"" + this.defaultGeom + "\"");
        } else {
            expr.accept((FilterVisitor)this);
        }
    }

    public void visit(GeometryFilter filter) throws RuntimeException {
        LOGGER.finer("exporting GeometryFilter");
        short filterType = filter.getFilterType();
        DefaultExpression left = (DefaultExpression)filter.getLeftGeometry();
        DefaultExpression right = (DefaultExpression)filter.getRightGeometry();
        if (!this.supportsGEOS) {
            if (filterType != 4) {
                throw new RuntimeException("without GEOS support, only the BBOX function is supported; failed to encode " + filterType);
            }
            this.encodeGeomFilter(filter, "distance", " < 0.00001", true);
            return;
        }
        int literalGeometryCount = 0;
        if (left != null && left.getType() == 104) {
            ++literalGeometryCount;
        }
        if (right != null && right.getType() == 104) {
            ++literalGeometryCount;
        }
        boolean constrainBBOX = literalGeometryCount == 1;
        boolean onlyBbox = filterType == 4 && this.looseBbox;
        try {
            boolean bl = constrainBBOX = constrainBBOX && filterType != 6;
            if (constrainBBOX) {
                this.encodeExpression(left);
                this.out.write(" && ");
                this.encodeExpression(right);
                if (!onlyBbox) {
                    this.out.write(" AND ");
                }
            }
            String closingParenthesis = ")";
            if (!onlyBbox) {
                if (filterType == 5) {
                    this.out.write("equals");
                } else if (filterType == 6) {
                    this.out.write("NOT (intersects");
                    closingParenthesis = String.valueOf(closingParenthesis) + ")";
                } else if (filterType == 7) {
                    this.out.write("intersects");
                } else if (filterType == 9) {
                    this.out.write("crosses");
                } else if (filterType == 10) {
                    this.out.write("within");
                } else if (filterType == 11) {
                    this.out.write("contains");
                } else if (filterType == 12) {
                    this.out.write("overlaps");
                } else if (filterType == 4) {
                    this.out.write("intersects");
                } else if (filterType == 8) {
                    this.out.write("touches");
                } else {
                    throw new RuntimeException("does not support filter type " + filterType);
                }
                this.out.write("(");
                this.encodeExpression(left);
                this.out.write(", ");
                this.encodeExpression(right);
                this.out.write(closingParenthesis);
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
            throw new RuntimeException("io error while writing", ioe);
        }
    }

    public void visitLiteralGeometry(LiteralExpression expression) throws IOException {
        Geometry bbox = (Geometry)expression.evaluate(null, Geometry.class);
        String geomText = null;
        if (bbox instanceof LinearRing) {
            LineString lineString = new LineString(((LinearRing)bbox).getCoordinateSequence(), bbox.getFactory());
            geomText = wkt.write((Geometry)lineString);
        } else {
            geomText = wkt.write(bbox);
        }
        this.out.write("GeometryFromText('" + geomText + "', " + this.srid + ")");
    }

    public void visit(LikeFilter filter) throws UnsupportedOperationException {
        char esc = filter.getEscape().charAt(0);
        char multi = filter.getWildcardMulti().charAt(0);
        char single = filter.getWildcardSingle().charAt(0);
        boolean matchCase = filter.isMatchingCase();
        String pattern = LikeFilterImpl.convertToSQL92((char)esc, (char)multi, (char)single, (boolean)matchCase, (String)filter.getPattern());
        DefaultExpression att = (DefaultExpression)filter.getValue();
        try {
            this.out.write(" ( ");
            if (!matchCase) {
                this.out.write("UPPER( ");
            }
            att.accept((FilterVisitor)this);
            if (!matchCase) {
                this.out.write(" ) LIKE '");
            } else {
                this.out.write(" LIKE '");
            }
            this.out.write(pattern);
            this.out.write("' ");
            if (att instanceof AttributeExpression && this.context != null && Date.class.isAssignableFrom(this.context)) {
                this.out.write(" OR ");
                if (!matchCase) {
                    this.out.write("UPPER( ");
                }
                att.accept((FilterVisitor)this);
                if (!matchCase) {
                    this.out.write(" ) LIKE '");
                } else {
                    this.out.write(" LIKE '");
                }
                this.out.write(String.valueOf(pattern) + " __:__:__'");
                this.out.write(" OR ");
                if (!matchCase) {
                    this.out.write("UPPER( ");
                }
                att.accept((FilterVisitor)this);
                if (!matchCase) {
                    this.out.write(" ) LIKE '");
                } else {
                    this.out.write(" LIKE '");
                }
                this.out.write(String.valueOf(pattern) + " __:__:_____'");
            }
            this.out.write(" ) ");
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
    }

    public void visit(LiteralExpression expression) throws RuntimeException {
        LOGGER.finer("exporting LiteralExpression");
        try {
            if (expression.getType() == 104) {
                this.visitLiteralGeometry(expression);
            } else {
                super.visit(expression);
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export expression" + ioe);
            throw new RuntimeException("io error while writing", ioe);
        }
    }

    public void visit(CompareFilter filter) throws RuntimeException {
        LOGGER.finer("exporting SQL ComparisonFilter");
        DefaultExpression left = (DefaultExpression)filter.getLeftValue();
        DefaultExpression right = (DefaultExpression)filter.getRightValue();
        LOGGER.finer("Filter type id is " + filter.getFilterType());
        LOGGER.finer("Filter type text is " + comparisions.get(new Integer(filter.getFilterType())));
        String type = (String)comparisions.get(new Integer(filter.getFilterType()));
        try {
            if (right == null && filter.getFilterType() == 14) {
                left.accept((FilterVisitor)this);
                this.out.write(" isnull");
            } else {
                if (!(filter.isMatchingCase() || filter.getFilterType() != 14 && filter.getFilterType() != 23 || left.getType() != 103 && right.getType() != 103)) {
                    this.out.write("lower(");
                    left.accept((FilterVisitor)this);
                    this.out.write(")");
                    this.out.write(" " + type + " ");
                    this.out.write("lower(");
                    right.accept((FilterVisitor)this);
                    this.out.write(")");
                    return;
                }
                left.accept((FilterVisitor)this);
                this.out.write(" " + type + " ");
                right.accept((FilterVisitor)this);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
    }
}

