/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.literal;

import java.util.HashMap;
import java.util.Map;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.AbstractProcess;
import org.geotools.process.literal.DoubleAdditionFactory;
import org.geotools.text.Text;
import org.geotools.util.NullProgressListener;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DoubleAdditionProcess
extends AbstractProcess {
    private boolean started = false;

    public DoubleAdditionProcess(DoubleAdditionFactory factory) {
        super(factory);
    }

    public ProcessFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        if (this.started) {
            throw new IllegalStateException("Process can only be run once");
        }
        this.started = true;
        if (null == monitor) {
            monitor = new NullProgressListener();
        }
        try {
            monitor.started();
            monitor.setTask(Text.text("Fetching arguments"));
            monitor.progress(10.0f);
            Double input_a = (Double)input.get(DoubleAdditionFactory.INPUT_A.key);
            Double input_b = (Double)input.get(DoubleAdditionFactory.INPUT_B.key);
            monitor.setTask(Text.text("Adding values"));
            monitor.progress(25.0f);
            if (monitor.isCanceled()) {
                Map<String, Object> map = null;
                return map;
            }
            Double sum = input_a + input_b;
            monitor.setTask(Text.text("Encoding result"));
            monitor.progress(90.0f);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(DoubleAdditionFactory.RESULT.key, sum);
            monitor.complete();
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            monitor.exceptionOccurred((Throwable)e);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            monitor.dispose();
        }
    }
}

