/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.Envelope;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class PropertyFeatureSource
extends AbstractFeatureLocking {
    String typeName;
    SimpleFeatureType featureType;
    PropertyDataStore store;
    long cacheTimestamp = 0L;
    ReferencedEnvelope cacheBounds = null;
    int cacheCount = -1;

    PropertyFeatureSource(PropertyDataStore propertyDataStore, String typeName) throws IOException {
        this.store = propertyDataStore;
        this.typeName = typeName;
        this.featureType = this.store.getSchema(typeName);
        this.store.listenerManager.addFeatureListener((FeatureSource)this, new FeatureListener(){

            public void changed(FeatureEvent featureEvent) {
                if (PropertyFeatureSource.this.cacheBounds != null) {
                    if (featureEvent.getEventType() == 1) {
                        PropertyFeatureSource.this.cacheBounds.expandToInclude((Envelope)featureEvent.getBounds());
                    } else {
                        PropertyFeatureSource.this.cacheBounds = null;
                    }
                }
                PropertyFeatureSource.this.cacheCount = -1;
            }
        });
        this.queryCapabilities = new QueryCapabilities(){

            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
    }

    public DataStore getDataStore() {
        return this.store;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.store.listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.store.listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public int getCount(Query query) {
        if (Filter.INCLUDE == query.getFilter() && this.getTransaction() == Transaction.AUTO_COMMIT) {
            File file = new File(this.store.directory, this.typeName + ".properties");
            if (this.cacheCount != -1 && file.lastModified() == this.cacheTimestamp) {
                return this.cacheCount;
            }
            this.cacheCount = this.countFile(file);
            this.cacheTimestamp = file.lastModified();
            return this.cacheCount;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countFile(File file) {
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(file));
            while (((LineNumberReader)reader).readLine() != null) {
            }
            int n = ((LineNumberReader)reader).getLineNumber() - 1;
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public ReferencedEnvelope getBounds() {
        File file = new File(this.store.directory, this.typeName + ".properties");
        if (this.cacheBounds != null && file.lastModified() == this.cacheTimestamp) {
            return this.cacheBounds;
        }
        try {
            this.cacheBounds = this.getFeatures().getBounds();
            this.cacheTimestamp = file.lastModified();
            return this.cacheBounds;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

