/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.RenderingHints;
import java.util.HashMap;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LabelWrapTest
extends TestCase {
    private static final long TIME = 10000L;
    FeatureSource<SimpleFeatureType, SimpleFeature> fs;
    ReferencedEnvelope bounds;

    protected void setUp() throws Exception {
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.setName("labelWrap");
        SimpleFeatureType type = builder.buildFeatureType();
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.0)), "A long label, no newlines"}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 4.0)), "A long label\nwith newlines"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f1);
        data.addFeature(f2);
        this.fs = data.getFeatureSource("labelWrap");
    }

    public void testNoAutoWrap() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textWrapDisabled.sld");
        this.renderLabels(this.fs, style, "Label wrap disabled");
    }

    public void testAutoWrap() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textWrapEnabled.sld");
        this.renderLabels(this.fs, style, "Label wrap enabled");
    }

    private void renderLabels(FeatureSource fs, Style style, String title) throws Exception {
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer(fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        HashMap<String, LabelCacheImpl> rendererParams = new HashMap<String, LabelCacheImpl>();
        LabelCacheImpl labelCache = new LabelCacheImpl();
        rendererParams.put("labelCache", labelCache);
        renderer.setRendererHints(rendererParams);
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender(title, renderer, 10000L, this.bounds);
    }
}

