/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.io.File;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LineTest
extends TestCase {
    private static final long TIME = 1000L;
    FeatureSource<SimpleFeatureType, SimpleFeature> fs;
    ReferencedEnvelope bounds;

    protected void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)((Object)this), (String)"line.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("line");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public void testLineCircle() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineCircle.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer(this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("Lines with circl stroke", renderer, 1000L, this.bounds);
    }

    public void testLineRailway() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineRailway.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer(this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("Lines with circl stroke", renderer, 1000L, this.bounds);
    }
}

