/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.io.IOException;
import java.util.Collection;
import javax.swing.event.EventListenerList;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.memory.CollectionSource;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.map.event.MapLayerListener;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapLayer
implements MapLayer {
    private CollectionSource source = null;
    protected FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    protected Style style;
    protected Query query = Query.ALL;
    protected String title;
    protected boolean visible;
    protected boolean selected;
    protected EventListenerList listenerList = null;
    protected FeatureListener sourceListener = new FeatureListener(){

        public void changed(FeatureEvent featureEvent) {
            DefaultMapLayer.this.fireMapLayerListenerLayerChanged(new MapLayerEvent(DefaultMapLayer.this, 3));
        }
    };

    public DefaultMapLayer(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource, Style style, String title) {
        if (featureSource == null || style == null || title == null) {
            // empty if block
        }
        this.featureSource = featureSource;
        this.style = style;
        this.title = title;
        this.visible = true;
        this.selected = false;
    }

    public DefaultMapLayer(CollectionSource source, Style style, String title) {
        if (source == null || style == null || title == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.style = style;
        this.title = title;
        this.visible = true;
        this.selected = false;
    }

    public DefaultMapLayer(FeatureSource<SimpleFeatureType, SimpleFeature> featureSource, Style style) {
        this(featureSource, style, "");
    }

    public DefaultMapLayer(FeatureCollection<SimpleFeatureType, SimpleFeature> collection, Style style, String title) {
        this((FeatureSource<SimpleFeatureType, SimpleFeature>)DataUtilities.source(collection), style, title);
    }

    public DefaultMapLayer(Collection collection, Style style, String title) {
        this(new CollectionSource(collection), style, title);
    }

    public DefaultMapLayer(FeatureCollection<SimpleFeatureType, SimpleFeature> collection, Style style) {
        this((FeatureSource<SimpleFeatureType, SimpleFeature>)DataUtilities.source(collection), style, "");
    }

    public DefaultMapLayer(Collection collection, Style style) {
    }

    public DefaultMapLayer(GridCoverage coverage, Style style) throws TransformException, FactoryRegistryException, SchemaException {
        this((FeatureCollection<SimpleFeatureType, SimpleFeature>)FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage)), style, "");
    }

    public DefaultMapLayer(AbstractGridCoverage2DReader reader, Style style, String title, GeneralParameterValue[] params) throws TransformException, FactoryRegistryException, SchemaException {
        this((FeatureCollection<SimpleFeatureType, SimpleFeature>)FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, (GeneralParameterValue[])params), style, title);
    }

    public DefaultMapLayer(AbstractGridCoverage2DReader reader, Style style, String title) throws TransformException, FactoryRegistryException, SchemaException {
        this((FeatureCollection<SimpleFeatureType, SimpleFeature>)FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, null), style, title);
    }

    public DefaultMapLayer(AbstractGridCoverage2DReader reader, Style style) throws TransformException, FactoryRegistryException, SchemaException {
        this((FeatureCollection<SimpleFeatureType, SimpleFeature>)FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)reader, null), style, "");
    }

    public DefaultMapLayer(GridCoverage coverage, Style style, String title) throws TransformException, FactoryRegistryException, SchemaException {
        this((FeatureCollection<SimpleFeatureType, SimpleFeature>)FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage)), style, title);
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource() {
        return this.featureSource;
    }

    @Override
    public CollectionSource getSource() {
        return this.source;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException();
        }
        this.style = style;
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 4));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException();
        }
        this.title = title;
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 2));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        MapLayerEvent event = new MapLayerEvent(this, 1);
        if (visible) {
            this.fireMapLayerListenerLayerShown(event);
        } else {
            this.fireMapLayerListenerLayerHidden(event);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        MapLayerEvent event = new MapLayerEvent(this, 6);
        if (selected) {
            this.fireMapLayerListenerLayerSelected(event);
        } else {
            this.fireMapLayerListenerLayerDeselected(event);
        }
    }

    @Override
    public Query getQuery() {
        return this.query == Query.ALL ? this.query : new DefaultQuery(this.query);
    }

    @Override
    public void setQuery(Query query) {
        if (query == null) {
            throw new NullPointerException("must provide a Query. Do you mean Query.ALL?");
        }
        this.query = new DefaultQuery(query);
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 5));
    }

    @Override
    public ReferencedEnvelope getBounds() {
        CoordinateReferenceSystem sourceCrs = ((SimpleFeatureType)this.featureSource.getSchema()).getCoordinateReferenceSystem();
        try {
            Envelope envelope;
            ReferencedEnvelope bounds = this.featureSource.getBounds();
            if (null != bounds) {
                return bounds;
            }
            if (sourceCrs != null && (envelope = CRS.getEnvelope((CoordinateReferenceSystem)sourceCrs)) != null) {
                return new ReferencedEnvelope(envelope);
            }
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ReferencedEnvelope(sourceCrs);
    }

    @Override
    public synchronized void addMapLayerListener(MapLayerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        if (this.listenerList.getListenerCount() == 0 && this.featureSource != null) {
            this.featureSource.addFeatureListener(this.sourceListener);
        }
        this.listenerList.add(MapLayerListener.class, listener);
    }

    @Override
    public synchronized void removeMapLayerListener(MapLayerListener listener) {
        this.listenerList.remove(MapLayerListener.class, listener);
        if (this.listenerList.getListenerCount() == 0 && this.featureSource != null) {
            this.featureSource.removeFeatureListener(this.sourceListener);
        }
    }

    protected void fireMapLayerListenerLayerChanged(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerChanged(event);
        }
    }

    protected void fireMapLayerListenerLayerShown(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerShown(event);
        }
    }

    protected void fireMapLayerListenerLayerHidden(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerHidden(event);
        }
    }

    protected void fireMapLayerListenerLayerSelected(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerSelected(event);
        }
    }

    protected void fireMapLayerListenerLayerDeselected(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerDeselected(event);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DefaultMapLayer[ ");
        if (this.title == null || this.title.length() == 0) {
            buf.append("UNNAMED");
        } else {
            buf.append(this.title);
        }
        if (this.visible) {
            buf.append(", VISIBLE");
        } else {
            buf.append(", HIDDEN");
        }
        if (this.selected) {
            buf.append(", SELECTED");
        } else {
            buf.append(", UNSELECTED");
        }
        buf.append(", style=");
        buf.append(this.style);
        buf.append(", data=");
        buf.append(this.featureSource);
        if (this.query != Query.ALL) {
            buf.append(", query=");
            buf.append(this.query);
        }
        buf.append("]");
        return buf.toString();
    }
}

