/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.test.TestData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LabelingTest
extends TestCase {
    private long timout = 3000L;
    private static final int CENTERX = 130;
    private static final int CENTERY = 40;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPointLabeling() throws Exception {
        SimpleFeatureCollection collection = this.createPointFeatureCollection();
        Style style = this.loadStyle("PointStyle.sld");
        LabelingTest.assertNotNull((Object)style);
        DefaultMapContext map = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.addLayer((FeatureCollection)collection, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)map);
        ReferencedEnvelope env = map.getLayerBounds();
        int boundary = 10;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testPointLabeling", (GTRenderer)renderer, this.timout, env);
    }

    private Style loadStyle(String sldFilename) throws IOException {
        StyleFactory factory = StyleFactoryFinder.createStyleFactory();
        URL surl = TestData.getResource((Object)((Object)this), (String)sldFilename);
        SLDParser stylereader = new SLDParser(factory, surl);
        Style style = stylereader.readXML()[0];
        return style;
    }

    private SimpleFeatureCollection createPointFeatureCollection() throws Exception {
        AttributeDescriptor[] types = new AttributeDescriptor[2];
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createPointFeature(2, 2, "LongLabel1", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(4, 4, "LongLabel2", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(0, 4, "LongLabel3", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(2, 6, "LongLabel6", (CoordinateReferenceSystem)crs, geomFac, types));
        return data.getFeatureSource("pointfeature").getFeatures();
    }

    private SimpleFeature createPointFeature(int x, int y, String name, CoordinateReferenceSystem crs, GeometryFactory geomFac, AttributeDescriptor[] types) throws Exception {
        Coordinate c = new Coordinate((double)x, (double)y);
        Point point = geomFac.createPoint(c);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (crs != null) {
            builder.add("point", point.getClass(), crs);
        } else {
            builder.add("centre", point.getClass());
        }
        builder.add("name", String.class);
        builder.setName("pointfeature");
        SimpleFeatureType type = builder.buildFeatureType();
        return SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point, name}, null);
    }

    public void testLineLabeling() throws Exception {
        SimpleFeatureCollection collection = this.createLineFeatureCollection();
        Style style = this.loadStyle("LineStyle.sld");
        LabelingTest.assertNotNull((Object)style);
        DefaultMapContext map = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.addLayer((FeatureCollection)collection, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)map);
        ReferencedEnvelope env = map.getLayerBounds();
        int boundary = 10;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testLineLabeling", (GTRenderer)renderer, this.timout, env);
    }

    private SimpleFeatureCollection createLineFeatureCollection() throws Exception {
        AttributeDescriptor[] types = new AttributeDescriptor[2];
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createLineFeature(10, 0, 0, 10, "LongLabel1", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createLineFeature(10, 10, 0, 0, "LongLabel2", (CoordinateReferenceSystem)crs, geomFac, types));
        return data.getFeatureSource("linefeature").getFeatures();
    }

    private SimpleFeature createLineFeature(int startx, int starty, int endx, int endy, String name, CoordinateReferenceSystem crs, GeometryFactory geomFac, AttributeDescriptor[] types) throws Exception {
        Coordinate[] c = new Coordinate[]{new Coordinate((double)startx, (double)starty), new Coordinate((double)endx, (double)endy)};
        LineString line = geomFac.createLineString(c);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (crs != null) {
            builder.add("line", line.getClass(), crs);
        } else {
            builder.add("centre", line.getClass());
        }
        builder.add("name", String.class);
        builder.setName("linefeature");
        SimpleFeatureType type = builder.buildFeatureType();
        return SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{line, name}, null);
    }

    public void testPolyLabeling() throws Exception {
        SimpleFeatureCollection collection = this.createPolyFeatureCollection();
        Style style = this.loadStyle("PolyStyle.sld");
        LabelingTest.assertNotNull((Object)style);
        DefaultMapContext map = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.addLayer((FeatureCollection)collection, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)map);
        ReferencedEnvelope env = map.getLayerBounds();
        int boundary = 10;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testPolyLabeling", (GTRenderer)renderer, this.timout, env);
    }

    private SimpleFeatureCollection createPolyFeatureCollection() throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createPolyFeature(135, 40, 140, 50, "LongLabel1", (CoordinateReferenceSystem)crs, geomFac));
        data.addFeature(this.createPolyFeature(130, 40, 140, 50, "LongLabel2", (CoordinateReferenceSystem)crs, geomFac));
        return data.getFeatureSource("polygonfeature").getFeatures();
    }

    private SimpleFeature createPolyFeature(int startx, int starty, int width, int height, String name, CoordinateReferenceSystem crs, GeometryFactory geomFac) throws Exception {
        Coordinate[] c = new Coordinate[]{new Coordinate((double)startx, (double)starty), new Coordinate((double)(startx + width), (double)starty), new Coordinate((double)(startx + width), (double)(starty + height)), new Coordinate((double)startx, (double)starty)};
        LinearRing line = geomFac.createLinearRing(c);
        Polygon poly = geomFac.createPolygon(line, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (crs != null) {
            builder.add("polygon", poly.getClass(), crs);
        } else {
            builder.add("centre", line.getClass());
        }
        builder.add("name", String.class);
        builder.setName("polygonfeature");
        SimpleFeatureType type = builder.buildFeatureType();
        return SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{poly, name}, null);
    }
}

