/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ContrastMethod;
import org.opengis.style.SelectedChannelType;

public class DisplayCoverageTest {
    private static final int WIDTH = 10;
    private static final String LOGGER_NAME = "org.geotools.rendering";
    private final boolean headless = GraphicsEnvironment.isHeadless();
    private final Rectangle bounds = new Rectangle(0, 0, 10, 10);
    private final ReferencedEnvelope env = new ReferencedEnvelope((Rectangle2D)this.bounds, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);

    @Test
    public void renderCoverage() {
        System.out.println("   render grid coverage");
        if (this.headless) {
            System.out.println("      Skipping test in headless build");
            return;
        }
        GridCoverage2D coverage = this.createCoverage();
        Style style = this.createCoverageStyle("1");
        MapContext context = new MapContext();
        context.addLayer((GridCoverage)coverage, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext(context);
        RenderListener listener = new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                Assert.fail((String)"Failed to render coverage");
            }
        };
        renderer.addRenderListener(listener);
        BufferedImage image = new BufferedImage(10, 10, 2);
        Graphics2D g2D = image.createGraphics();
        Logger logger = Logger.getLogger(LOGGER_NAME);
        Level savedLevel = logger.getLevel();
        logger.setLevel(Level.OFF);
        try {
            renderer.paint(g2D, this.bounds, this.env);
        }
        finally {
            logger.setLevel(savedLevel);
        }
    }

    private GridCoverage2D createCoverage() {
        GridCoverageFactory gcf = CoverageFactoryFinder.getGridCoverageFactory(null);
        float[][] matrix = new float[10][10];
        Random rand = new Random();
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                matrix[i][j] = rand.nextFloat() * 255.0f;
                ++j;
            }
            ++i;
        }
        return gcf.create((CharSequence)"coverage", matrix, (Envelope)this.env);
    }

    private Style createCoverageStyle(String bandName) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        ContrastEnhancement ce = sf.contrastEnhancement((Expression)ff.literal(1.0), ContrastMethod.NORMALIZE);
        org.geotools.styling.SelectedChannelType sct = sf.createSelectedChannelType(bandName, ce);
        RasterSymbolizer sym = sf.getDefaultRasterSymbolizer();
        org.geotools.styling.ChannelSelection sel = sf.channelSelection((SelectedChannelType)sct);
        sym.setChannelSelection((ChannelSelection)sel);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }
}

