/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.logging.Level;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Style;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridCoverageLayer
extends Layer {
    protected Style style;
    protected GridCoverage2D coverage;

    public GridCoverageLayer(GridCoverage2D coverage, Style style) {
        this.coverage = coverage;
        this.style = style;
    }

    public GridCoverageLayer(GridCoverage2D coverage, Style style, String title) {
        this.coverage = coverage;
        this.style = style;
        this.setTitle(title);
    }

    public void dispose() {
        if (this.coverage == null) {
            try {
                this.coverage.dispose(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.coverage = null;
        }
        if (this.style == null) {
            this.style = null;
        }
        super.dispose();
    }

    public GridCoverage2D getCoverage() {
        return this.coverage;
    }

    public ReferencedEnvelope getBounds() {
        if (this.coverage != null) {
            CoordinateReferenceSystem crs = this.coverage.getCoordinateReferenceSystem();
            Envelope2D bounds = this.coverage.getEnvelope2D();
            if (bounds != null) {
                return new ReferencedEnvelope((Envelope)bounds);
            }
            if (crs != null) {
                return new ReferencedEnvelope(crs);
            }
        }
        return null;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException();
        }
        this.style = style;
        this.fireMapLayerListenerLayerChanged(4);
    }

    public SimpleFeatureCollection toFeatureCollection() {
        try {
            SimpleFeatureCollection collection = FeatureUtilities.wrapGridCoverage((GridCoverage2D)this.coverage);
            return collection;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Coverage could not be converted to FeatureCollection", e);
            return null;
        }
    }
}

