/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.logging.Level;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.Style;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridReaderLayer
extends Layer {
    protected Style style;
    protected AbstractGridCoverage2DReader reader;
    protected GeneralParameterValue[] params;

    public GridReaderLayer(AbstractGridCoverage2DReader reader, Style style, String title, GeneralParameterValue[] params) {
        this.reader = reader;
        this.params = params;
        this.style = style;
        this.setTitle(title);
    }

    public void dispose() {
        if (this.reader != null) {
            try {
                this.reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.style != null) {
            this.style = null;
        }
        if (this.params != null) {
            this.params = null;
        }
        super.dispose();
    }

    public ReferencedEnvelope getBounds() {
        if (this.reader != null) {
            CoordinateReferenceSystem crs = this.reader.getCrs();
            GeneralEnvelope envelope = this.reader.getOriginalEnvelope();
            if (envelope != null) {
                return new ReferencedEnvelope((Envelope)envelope);
            }
            if (crs != null) {
                return new ReferencedEnvelope(crs);
            }
        }
        return null;
    }

    public GridReaderLayer(AbstractGridCoverage2DReader reader, Style style, String title) {
        this.reader = reader;
        this.style = style;
        this.setTitle(title);
    }

    public GridReaderLayer(AbstractGridCoverage2DReader reader, Style style) {
        this.reader = reader;
        this.style = style;
    }

    public AbstractGridCoverage2DReader getReader() {
        return this.reader;
    }

    public GeneralParameterValue[] getParams() {
        return this.params;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException();
        }
        this.style = style;
        this.fireMapLayerListenerLayerChanged(4);
    }

    public SimpleFeatureCollection toFeatureCollection() {
        try {
            SimpleFeatureCollection collection = FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)this.reader, (GeneralParameterValue[])this.params);
            return collection;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Coverage could not be converted to FeatureCollection", e);
            return null;
        }
    }
}

