/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.MapViewport;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.map.event.MapLayerListener;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapContent {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.map");
    private CopyOnWriteArrayList<Layer> layerList;
    private CopyOnWriteArrayList<MapLayerListListener> mapListeners;
    private HashMap<String, Object> userData;
    private String title;
    private CopyOnWriteArrayList<PropertyChangeListener> propertyListeners;
    protected MapViewport viewport;
    private MapLayerListener layerListener;

    public MapContent() {
    }

    protected void finalize() throws Throwable {
        if (this.layerList != null && !this.layerList.isEmpty()) {
            LOGGER.severe("Call MapContent dispose() to prevent memory leaks");
        }
        super.finalize();
    }

    public void dispose() {
        if (this.mapListeners != null) {
            this.mapListeners.clear();
            this.mapListeners = null;
        }
        if (this.layerList != null) {
            for (Layer layer : this.layerList) {
                if (layer == null) continue;
                if (this.layerListener != null) {
                    layer.removeMapLayerListener(this.layerListener);
                }
                layer.dispose();
            }
            this.layerList.clear();
            this.layerList = null;
        }
        if (this.layerListener != null) {
            this.layerListener = null;
        }
        if (this.propertyListeners != null) {
            this.propertyListeners.clear();
            this.propertyListeners = null;
        }
        this.title = null;
        if (this.userData != null) {
            this.userData.clear();
            this.userData = null;
        }
    }

    public MapContent(MapContext context) {
        MapLayer[] mapLayerArray = context.getLayers();
        int n = mapLayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MapLayer mapLayer = mapLayerArray[n2];
            this.layers().add(mapLayer.toLayer());
            ++n2;
        }
        if (context.getTitle() != null) {
            this.setTitle(context.getTitle());
        }
        if (context.getAbstract() != null) {
            this.getUserData().put("abstract", context.getAbstract());
        }
        if (context.getContactInformation() != null) {
            this.getUserData().put("contact", context.getContactInformation());
        }
        if (context.getKeywords() != null) {
            this.getUserData().put("keywords", context.getKeywords());
        }
        if (context.getAreaOfInterest() != null) {
            this.getViewport().setBounds(context.getAreaOfInterest());
        }
    }

    @Deprecated
    public MapContent(CoordinateReferenceSystem crs) {
        this.getViewport().setCoordinateReferenceSystem(crs);
    }

    @Deprecated
    public MapContent(MapLayer[] array) {
        this(array, null);
    }

    @Deprecated
    public MapContent(MapLayer[] array, CoordinateReferenceSystem crs) {
        this(array, "Untitled", "", "", null, crs);
    }

    @Deprecated
    public MapContent(MapLayer[] array, String title, String contextAbstract, String contactInformation, String[] keywords) {
        this(array, title, contextAbstract, contactInformation, keywords, null);
    }

    @Deprecated
    public MapContent(MapLayer[] array, String title, String contextAbstract, String contactInformation, String[] keywords, CoordinateReferenceSystem crs) {
        if (array != null) {
            MapLayer[] mapLayerArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                MapLayer mapLayer = mapLayerArray[n2];
                if (mapLayer != null) {
                    Layer layer = mapLayer.toLayer();
                    this.layers().add(layer);
                }
                ++n2;
            }
        }
        if (title != null) {
            this.setTitle(title);
        }
        if (contextAbstract != null) {
            this.getUserData().put("abstract", contextAbstract);
        }
        if (contactInformation != null) {
            this.getUserData().put("contact", contactInformation);
        }
        if (keywords != null) {
            this.getUserData().put("keywords", keywords);
        }
        if (crs != null) {
            this.getViewport().setCoordinateReferenceSystem(crs);
        }
    }

    public void addMapLayerListListener(MapLayerListListener listener) {
        boolean added;
        if (this.mapListeners == null) {
            this.mapListeners = new CopyOnWriteArrayList();
        }
        if ((added = this.mapListeners.addIfAbsent(listener)) && this.mapListeners.size() == 1) {
            this.listenToMapLayers(true);
        }
    }

    protected synchronized void listenToMapLayers(boolean listen) {
        if (this.mapListeners == null || this.mapListeners.isEmpty()) {
            return;
        }
        if (this.layerListener == null) {
            this.layerListener = new MapLayerListener(){

                public void layerShown(MapLayerEvent event) {
                    Layer layer = (Layer)event.getSource();
                    int index = MapContent.this.layerList.indexOf(layer);
                    MapContent.this.fireLayerEvent(layer, index, event);
                }

                public void layerSelected(MapLayerEvent event) {
                    Layer layer = (Layer)event.getSource();
                    int index = MapContent.this.layerList.indexOf(layer);
                    MapContent.this.fireLayerEvent(layer, index, event);
                }

                public void layerHidden(MapLayerEvent event) {
                    Layer layer = (Layer)event.getSource();
                    int index = MapContent.this.layerList.indexOf(layer);
                    MapContent.this.fireLayerEvent(layer, index, event);
                }

                public void layerDeselected(MapLayerEvent event) {
                    Layer layer = (Layer)event.getSource();
                    int index = MapContent.this.layerList.indexOf(layer);
                    MapContent.this.fireLayerEvent(layer, index, event);
                }

                public void layerChanged(MapLayerEvent event) {
                    Layer layer = (Layer)event.getSource();
                    int index = MapContent.this.layerList.indexOf(layer);
                    MapContent.this.fireLayerEvent(layer, index, event);
                }
            };
        }
        if (listen) {
            for (Layer layer : this.layerList) {
                layer.addMapLayerListener(this.layerListener);
            }
        } else {
            for (Layer layer : this.layerList) {
                layer.removeMapLayerListener(this.layerListener);
            }
        }
    }

    public void removeMapLayerListListener(MapLayerListListener listener) {
        if (this.mapListeners != null) {
            this.mapListeners.remove(listener);
        }
    }

    public boolean addLayer(Layer layer) {
        return this.layers().addIfAbsent(layer);
    }

    public boolean removeLayer(Layer layer) {
        return this.layers().remove(layer);
    }

    public void moveLayer(int sourcePosition, int destPosition) {
        Layer destLayer = this.layerList.get(destPosition);
        Layer sourceLayer = this.layerList.get(sourcePosition);
        this.layerList.set(destPosition, sourceLayer);
        this.layerList.set(sourcePosition, destLayer);
    }

    public synchronized CopyOnWriteArrayList<Layer> layers() {
        if (this.layerList == null) {
            this.layerList = new CopyOnWriteArrayList<Layer>(){
                private static final long serialVersionUID = 8011733882551971475L;

                @Override
                public void add(int index, Layer element) {
                    super.add(index, element);
                    if (MapContent.this.layerListener != null) {
                        element.addMapLayerListener(MapContent.this.layerListener);
                    }
                    MapContent.this.fireLayerAdded(element, index, index);
                }

                @Override
                public boolean add(Layer element) {
                    boolean added = super.add(element);
                    if (added) {
                        if (MapContent.this.layerListener != null) {
                            element.addMapLayerListener(MapContent.this.layerListener);
                        }
                        MapContent.this.fireLayerAdded(element, this.size() - 1, this.size() - 1);
                    }
                    return added;
                }

                @Override
                public boolean addAll(Collection<? extends Layer> c) {
                    int start = this.size() - 1;
                    boolean added = super.addAll(c);
                    if (MapContent.this.layerListener != null) {
                        for (Layer layer : c) {
                            layer.addMapLayerListener(MapContent.this.layerListener);
                        }
                    }
                    MapContent.this.fireLayerAdded(null, start, this.size() - 1);
                    return added;
                }

                @Override
                public boolean addAll(int index, Collection<? extends Layer> c) {
                    boolean added = super.addAll(index, c);
                    if (MapContent.this.layerListener != null) {
                        for (Layer layer : c) {
                            layer.addMapLayerListener(MapContent.this.layerListener);
                        }
                    }
                    MapContent.this.fireLayerAdded(null, index, this.size() - 1);
                    return added;
                }

                @Override
                public int addAllAbsent(Collection<? extends Layer> c) {
                    int start = this.size() - 1;
                    int added = super.addAllAbsent(c);
                    if (MapContent.this.layerListener != null) {
                        for (Layer layer : c) {
                            layer.addMapLayerListener(MapContent.this.layerListener);
                        }
                    }
                    MapContent.this.fireLayerAdded(null, start, this.size() - 1);
                    return added;
                }

                @Override
                public boolean addIfAbsent(Layer e) {
                    boolean added = super.addIfAbsent(e);
                    if (added) {
                        MapContent.this.fireLayerAdded(e, this.size() - 1, this.size() - 1);
                    }
                    return added;
                }

                @Override
                public void clear() {
                    for (Layer element : this) {
                        if (MapContent.this.layerListener != null) {
                            element.removeMapLayerListener(MapContent.this.layerListener);
                        }
                        element.dispose();
                    }
                    super.clear();
                    MapContent.this.fireLayerRemoved(null, -1, -1);
                }

                @Override
                public Layer remove(int index) {
                    Layer removed = (Layer)super.remove(index);
                    MapContent.this.fireLayerRemoved(removed, index, index);
                    if (MapContent.this.layerListener != null) {
                        removed.removeMapLayerListener(MapContent.this.layerListener);
                    }
                    removed.dispose();
                    return removed;
                }

                @Override
                public boolean remove(Object o) {
                    boolean removed = super.remove(o);
                    if (removed) {
                        MapContent.this.fireLayerRemoved((Layer)o, -1, -1);
                        if (o instanceof Layer) {
                            Layer element = (Layer)o;
                            if (MapContent.this.layerListener != null) {
                                element.removeMapLayerListener(MapContent.this.layerListener);
                            }
                            element.dispose();
                        }
                    }
                    return removed;
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    for (Object obj : c) {
                        if (!this.contains(obj) || !(obj instanceof Layer)) continue;
                        Layer element = (Layer)obj;
                        if (MapContent.this.layerListener != null) {
                            element.removeMapLayerListener(MapContent.this.layerListener);
                        }
                        element.dispose();
                    }
                    boolean removed = super.removeAll(c);
                    MapContent.this.fireLayerRemoved(null, 0, this.size() - 1);
                    return removed;
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    for (Object obj : c) {
                        if (this.contains(obj) || !(obj instanceof Layer)) continue;
                        Layer element = (Layer)obj;
                        if (MapContent.this.layerListener != null) {
                            element.removeMapLayerListener(MapContent.this.layerListener);
                        }
                        element.dispose();
                    }
                    boolean removed = super.retainAll(c);
                    MapContent.this.fireLayerRemoved(null, 0, this.size() - 1);
                    return removed;
                }
            };
        }
        return this.layerList;
    }

    protected void fireLayerAdded(Layer element, int fromIndex, int toIndex) {
        if (this.mapListeners == null) {
            return;
        }
        MapLayerListEvent event = new MapLayerListEvent(this, element, fromIndex, toIndex);
        for (MapLayerListListener mapLayerListListener : this.mapListeners) {
            try {
                mapLayerListListener.layerAdded(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerAdded", t.getLocalizedMessage(), t);
            }
        }
    }

    protected void fireLayerRemoved(Layer element, int fromIndex, int toIndex) {
        if (this.mapListeners == null) {
            return;
        }
        MapLayerListEvent event = new MapLayerListEvent(this, element, fromIndex, toIndex);
        for (MapLayerListListener mapLayerListListener : this.mapListeners) {
            try {
                mapLayerListListener.layerRemoved(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerAdded", t.getLocalizedMessage(), t);
            }
        }
    }

    protected void fireLayerEvent(Layer element, int index, MapLayerEvent layerEvent) {
        if (this.mapListeners == null) {
            return;
        }
        MapLayerListEvent mapEvent = new MapLayerListEvent(this, element, index, layerEvent);
        for (MapLayerListListener mapLayerListListener : this.mapListeners) {
            try {
                mapLayerListListener.layerChanged(mapEvent);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.logp(Level.FINE, mapLayerListListener.getClass().getName(), "layerAdded", t.getLocalizedMessage(), t);
            }
        }
    }

    ReferencedEnvelope getMaxBounds() throws IOException {
        CoordinateReferenceSystem mapCrs = this.getCoordinateReferenceSystem();
        ReferencedEnvelope maxBounds = null;
        if (this.layerList != null) {
            for (Layer layer : this.layerList) {
                ReferencedEnvelope normalized;
                ReferencedEnvelope layerBounds;
                if (layer == null || (layerBounds = layer.getBounds()) == null || layerBounds.isEmpty() || layerBounds.isNull()) continue;
                if (mapCrs == null) {
                    maxBounds = new ReferencedEnvelope(layerBounds);
                    mapCrs = layerBounds.getCoordinateReferenceSystem();
                    continue;
                }
                if (CRS.equalsIgnoreMetadata((Object)mapCrs, (Object)layerBounds.getCoordinateReferenceSystem())) {
                    normalized = layerBounds;
                } else {
                    try {
                        normalized = layerBounds.transform(mapCrs, true);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Unable to transform: {0}", e);
                        continue;
                    }
                }
                if (maxBounds == null) {
                    maxBounds = normalized;
                    continue;
                }
                maxBounds.expandToInclude((Envelope)normalized);
            }
        }
        if (maxBounds == null && mapCrs != null) {
            maxBounds = new ReferencedEnvelope(mapCrs);
        }
        return maxBounds;
    }

    public synchronized MapViewport getViewport() {
        if (this.viewport == null) {
            this.viewport = new MapViewport();
        }
        return this.viewport;
    }

    public void addMapBoundsListener(MapBoundsListener listener) {
        this.getViewport().addMapBoundsListener(listener);
    }

    public void removeMapBoundsListener(MapBoundsListener listener) {
        this.getViewport().removeMapBoundsListener(listener);
    }

    ReferencedEnvelope getBounds() {
        return this.getViewport().getBounds();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getViewport().getCoordianteReferenceSystem();
    }

    void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.getViewport().setCoordinateReferenceSystem(crs);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new CopyOnWriteArrayList();
        }
        if (!this.propertyListeners.contains(listener)) {
            this.propertyListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    public synchronized Map<String, Object> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>(){
                private static final long serialVersionUID = 8011733882551971475L;

                @Override
                public Object put(String key, Object value) {
                    Object old = super.put(key, value);
                    MapContent.this.fireProperty(key, old, value);
                    return old;
                }

                @Override
                public Object remove(Object key) {
                    Object old = super.remove(key);
                    MapContent.this.fireProperty((String)key, old, null);
                    return old;
                }

                @Override
                public void putAll(Map<? extends String, ? extends Object> m) {
                    super.putAll(m);
                    MapContent.this.fireProperty("userData", null, null);
                }

                @Override
                public void clear() {
                    super.clear();
                    MapContent.this.fireProperty("userData", null, null);
                }
            };
        }
        return this.userData;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.fireProperty("title", old, title);
    }

    protected void fireProperty(String propertyName, Object old, Object value) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "propertyName", old, value);
        for (PropertyChangeListener propertyChangeListener : this.propertyListeners) {
            try {
                propertyChangeListener.propertyChange(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.logp(Level.FINE, propertyChangeListener.getClass().getName(), "propertyChange", t.getLocalizedMessage(), t);
            }
        }
    }
}

