/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import org.geotools.referencing.piecewise.DefaultDomainElement1D;
import org.geotools.referencing.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.Domain1D;
import org.geotools.referencing.piecewise.DomainElement1D;
import org.geotools.referencing.piecewise.PiecewiseUtilities;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomain1D<E extends DefaultDomainElement1D>
extends AbstractList<E>
implements Domain1D<E> {
    private E[] elements;
    private boolean hasGaps;
    private E main;
    private double[] minimums;
    private InternationalString name;
    private NumberRange<?> range;
    private int hashCode = -1;

    @Override
    public synchronized InternationalString getName() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer(30);
            Locale locale = Locale.getDefault();
            if (this.main != null) {
                buffer.append(((DefaultDomainElement1D)this.main).getName().toString(locale));
            } else {
                buffer.append('(');
                buffer.append(Vocabulary.getResources(locale).getString(0));
                buffer.append(')');
            }
            this.name = SimpleInternationalString.wrap((CharSequence)buffer.toString());
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NumberRange<? extends Number> getApproximateDomainRange() {
        E[] EArray = this.elements;
        synchronized (this.elements) {
            if (this.range == null) {
                NumberRange range = null;
                E[] EArray2 = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    E element = EArray2[n2];
                    NumberRange extent = ((DefaultDomainElement1D)element).getRange();
                    if (!Double.isNaN(extent.getMinimum()) && !Double.isNaN(extent.getMaximum())) {
                        range = range != null ? new NumberRange((Range)range.union(extent)) : extent;
                    }
                    ++n2;
                }
                this.range = range;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.range;
        }
    }

    public DefaultDomain1D(E[] inDomainElements) {
        this.init((DefaultDomainElement1D[])inDomainElements);
    }

    private void init(E[] inDomainElements) throws IllegalArgumentException, MissingResourceException {
        PiecewiseUtilities.ensureNonNull("DomainElement1D[]", inDomainElements);
        this.elements = inDomainElements == null ? new DefaultDomainElement1D[]{new DefaultPassthroughPiecewiseTransform1DElement("p0")} : (DefaultDomainElement1D[])inDomainElements.clone();
        Arrays.sort(this.elements);
        this.hasGaps = false;
        this.minimums = new double[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            E c = this.elements[i];
            double inMinimum = this.minimums[i] = ((DefaultDomainElement1D)c).getInputMinimum();
            if (i != 0) {
                assert (!(inMinimum < this.minimums[i - 1])) : inMinimum;
                E previous = this.elements[i - 1];
                if (PiecewiseUtilities.compare(inMinimum, ((DefaultDomainElement1D)previous).getInputMaximum()) <= 0) {
                    PiecewiseUtilities.domainElementsOverlap(this.elements, i);
                }
                if (!Double.isNaN(inMinimum) && inMinimum != ((DefaultDomainElement1D)previous).getRange().getMaximum(false)) {
                    this.hasGaps = true;
                }
            }
            ++i;
        }
        double range = 0.0;
        Object main = null;
        int i2 = this.elements.length;
        while (--i2 >= 0) {
            E candidate = this.elements[i2];
            if (Double.isInfinite(((DefaultDomainElement1D)candidate).getInputMinimum()) && Double.isInfinite(((DefaultDomainElement1D)candidate).getInputMaximum())) {
                range = Double.POSITIVE_INFINITY;
                main = candidate;
                continue;
            }
            double candidateRange = ((DefaultDomainElement1D)candidate).getInputMaximum() - ((DefaultDomainElement1D)candidate).getInputMinimum();
            if (!(candidateRange >= range)) continue;
            range = candidateRange;
            main = candidate;
        }
        this.main = main;
        assert (PiecewiseUtilities.isSorted(this.elements));
    }

    @Override
    public E findDomainElement(double value) {
        E domainElement1D;
        int i = this.getDomainElementIndex(value);
        if (i < 0) {
            return null;
        }
        if (i > this.elements.length) {
            return null;
        }
        if (i < this.elements.length) {
            domainElement1D = this.elements[i];
            if (((DefaultDomainElement1D)domainElement1D).contains(value)) {
                return domainElement1D;
            }
            if (i == 0) {
                return null;
            }
        }
        if (((DefaultDomainElement1D)(domainElement1D = this.elements[i - 1])).contains(value)) {
            return domainElement1D;
        }
        assert (i >= this.elements.length || this.hasGaps) : value;
        return null;
    }

    private int getDomainElementIndex(double sample) {
        int i = -1;
        i = PiecewiseUtilities.binarySearch(this.minimums, sample);
        if (i >= 0) {
            assert (Double.doubleToRawLongBits(sample) == Double.doubleToRawLongBits(this.minimums[i]));
            return i;
        }
        assert (i == Arrays.binarySearch(this.minimums, sample)) : i;
        i = -i - 1;
        return i;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public E get(int i) {
        return this.elements[i];
    }

    @Override
    public Object[] toArray() {
        return (DomainElement1D[])this.elements.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultDomain1D)) {
            return false;
        }
        DefaultDomain1D that = (DefaultDomain1D)object;
        if (this.getEquivalenceClass() != that.getEquivalenceClass()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!this.getApproximateDomainRange().equals(that.getApproximateDomainRange())) {
            return false;
        }
        if (Arrays.equals(this.elements, that.elements)) {
            assert (Arrays.equals(this.minimums, that.minimums));
            return true;
        }
        return false;
    }

    protected Class<?> getEquivalenceClass() {
        return DefaultDomain1D.class;
    }

    @Override
    public boolean hasGaps() {
        return this.hasGaps;
    }

    public E getMain() {
        return this.main;
    }

    public double[] getMinimums() {
        return (double[])this.minimums.clone();
    }

    @Override
    public int hashCode() {
        if (this.hashCode < 0) {
            int result = Utilities.deepHashCode(this.elements);
            result = Utilities.deepHashCode((Object)this.minimums);
            result = Utilities.hash((Object)this.getName(), (int)result);
            this.hashCode = Utilities.hash(this.getApproximateDomainRange(), (int)this.hashCode);
        }
        return this.hashCode;
    }
}

