/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.geotools.image.TransfertRectIter;
import org.geotools.image.jai.Registry;
import org.geotools.referencing.piecewise.DefaultDomain1D;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1D;
import org.geotools.referencing.piecewise.DomainElement1D;
import org.geotools.referencing.piecewise.PiecewiseTransform1D;
import org.geotools.referencing.piecewise.PiecewiseTransform1DElement;
import org.geotools.renderer.i18n.Errors;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPiecewise<T extends PiecewiseTransform1DElement>
extends ColormapOpImage {
    public static final String OPERATION_NAME = "org.geotools.GenericPiecewise";
    private final PiecewiseTransform1D<T> piecewise;
    private final boolean isByteData;
    private byte[][] lut;
    private double gapsValue = Double.NaN;
    private boolean hasGapsValue = false;
    private final boolean useLast;

    private GenericPiecewise(RenderedImage image, PiecewiseTransform1D<T> lic, RenderingHints hints) {
        super(image, RIFUtil.getImageLayoutHint((RenderingHints)hints), (Map)hints, false);
        this.piecewise = lic;
        int numBands = this.sampleModel.getNumBands();
        boolean bl = this.isByteData = this.sampleModel.getTransferType() == 0;
        if (this.piecewise.hasDefaultValue()) {
            this.gapsValue = this.piecewise.getDefaultValue();
            this.hasGapsValue = true;
        }
        this.useLast = this.piecewise instanceof DefaultDomain1D;
        if (this.isByteData) {
            try {
                this.createLUT(numBands);
            }
            catch (TransformException e) {
                RuntimeException re = new RuntimeException(e);
                throw re;
            }
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        PlanarImage source = sources[0];
        WritableRectIter iterator = RectIterFactory.createWritable((WritableRaster)dest, (Rectangle)destRect);
        iterator = TransfertRectIter.create((RectIter)RectIterFactory.create((RenderedImage)source, (Rectangle)destRect), (WritableRectIter)iterator);
        PiecewiseTransform1DElement last = null;
        int bandNumber = 0;
        do {
            try {
                iterator.startLines();
                if (!iterator.finishedLines()) {
                    do {
                        iterator.startPixels();
                        if (iterator.finishedPixels()) continue;
                        do {
                            if (this.isByteData) {
                                int in = iterator.getSample() & 0xFF;
                                int out = 0xFF & this.lut[bandNumber][in];
                                iterator.setSample(out);
                                continue;
                            }
                            last = this.domainSearch(iterator, last, bandNumber);
                        } while (!iterator.nextPixelDone());
                    } while (!iterator.nextLineDone());
                }
            }
            catch (Exception cause) {
                RasterFormatException exception = new RasterFormatException(cause.getLocalizedMessage());
                exception.initCause(cause);
                throw exception;
            }
            ++bandNumber;
        } while (iterator.finishedBands());
    }

    private PiecewiseTransform1DElement domainSearch(WritableRectIter iterator, PiecewiseTransform1DElement last, int bandNumber) throws TransformException {
        PiecewiseTransform1DElement transformElement;
        double value = iterator.getSampleDouble();
        if (this.useLast) {
            if (last != null && last.contains(value)) {
                transformElement = last;
            } else {
                last = transformElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
            }
        } else {
            transformElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
        }
        if (transformElement != null) {
            iterator.setSample(transformElement.transform(value));
        } else if (this.hasGapsValue) {
            iterator.setSample(this.gapsValue);
        } else {
            throw new IllegalArgumentException(Errors.format(9, Double.toString(value)));
        }
        return last;
    }

    public static boolean register(JAI jai) {
        return Registry.registerRIF((JAI)jai, (OperationDescriptor)new Descriptor(), (String)OPERATION_NAME, (ContextualRenderedImageFactory)((Object)new CRIF()));
    }

    private void createLUT(int numBands) throws TransformException {
        byte[][] data = new byte[numBands][];
        int band = 0;
        while (band < numBands) {
            data[band] = new byte[256];
            byte[] table = data[band];
            DomainElement1D lastPiecewiseElement = null;
            int value = 0;
            while (value < 256) {
                DomainElement1D piecewiseElement;
                if (this.useLast) {
                    if (lastPiecewiseElement != null && lastPiecewiseElement.contains(value)) {
                        piecewiseElement = lastPiecewiseElement;
                    } else {
                        piecewiseElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
                        lastPiecewiseElement = piecewiseElement;
                    }
                } else {
                    piecewiseElement = (PiecewiseTransform1DElement)this.piecewise.findDomainElement(value);
                }
                if (piecewiseElement != null) {
                    table[value] = ImageUtil.clampRoundByte((double)piecewiseElement.transform(value));
                } else if (this.hasGapsValue) {
                    table[value] = ImageUtil.clampRoundByte((double)this.gapsValue);
                } else {
                    throw new IllegalArgumentException(Errors.format(9, Double.toString(value)));
                }
                ++value;
            }
            ++band;
        }
        this.lut = data;
    }

    protected void transformColormap(byte[][] colormap) {
        int b = 0;
        while (b < 3) {
            byte[] map = colormap[b];
            byte[] luTable = this.lut[b >= this.lut.length ? 0 : b];
            int mapSize = map.length;
            int i = 0;
            while (i < mapSize) {
                map[i] = luTable[map[i] & 0xFF];
                ++i;
            }
            ++b;
        }
    }

    /* synthetic */ GenericPiecewise(RenderedImage renderedImage, PiecewiseTransform1D piecewiseTransform1D, RenderingHints renderingHints, GenericPiecewise genericPiecewise) {
        this(renderedImage, piecewiseTransform1D, renderingHints);
    }

    private static final class CRIF
    extends CRIFImpl {
        private CRIF() {
        }

        public RenderedImage create(ParameterBlock param, RenderingHints hints) {
            RenderedImage image = (RenderedImage)param.getSource(0);
            PiecewiseTransform1D lic = (PiecewiseTransform1D)param.getObjectParameter(0);
            return new GenericPiecewise(image, lic, hints, null);
        }
    }

    private static final class Descriptor
    extends OperationDescriptorImpl {
        private static final long serialVersionUID = 7954257625240335874L;

        public Descriptor() {
            super((String[][])new String[][]{{"GlobalName", GenericPiecewise.OPERATION_NAME}, {"LocalName", GenericPiecewise.OPERATION_NAME}, {"Vendor", "Geotools 2"}, {"Description", "Generic Piecewise Transformation"}, {"DocURL", "http://www.geotools.org/"}, {"Version", "1.0"}}, new String[]{"rendered"}, 1, new String[]{"Domain1D", "bandIndex"}, new Class[]{DefaultPiecewiseTransform1D.class, Integer.class}, new Object[]{NO_PARAMETER_DEFAULT, new Integer(-1)}, null);
        }

        protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
            if (!super.validateParameters(modeName, param, message)) {
                return false;
            }
            RenderedImage source = (RenderedImage)param.getSource(0);
            PiecewiseTransform1D lic = (PiecewiseTransform1D)param.getObjectParameter(0);
            if (lic == null) {
                return false;
            }
            int numBands = source.getSampleModel().getNumBands();
            int bandIndex = param.getIntParameter(1);
            if (bandIndex == -1) {
                return true;
            }
            return bandIndex >= 0 && bandIndex < numBands;
        }
    }
}

