/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.crs.GeographicHandlerFactory;
import org.geotools.renderer.crs.MercatorHandlerFactory;
import org.geotools.renderer.crs.PolarStereographicHandlerFactory;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.TransverseMercatorHandlerFactory;

public class ProjectionHandlerFinder {
    static List<ProjectionHandlerFactory> factories = new ArrayList<ProjectionHandlerFactory>();

    static {
        factories.add(new GeographicHandlerFactory());
        factories.add(new MercatorHandlerFactory());
        factories.add(new TransverseMercatorHandlerFactory());
        factories.add(new PolarStereographicHandlerFactory());
    }

    public static ProjectionHandler getHandler(ReferencedEnvelope renderingArea, boolean wrap) {
        if (renderingArea.getCoordinateReferenceSystem() == null) {
            return null;
        }
        for (ProjectionHandlerFactory factory : factories) {
            ProjectionHandler handler = factory.getHandler(renderingArea, wrap);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

