/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;

class WrappingCoordinateFilter
implements GeometryComponentFilter {
    static final int EAST_TO_WEST = 0;
    static final int WEST_TO_EAST = 1;
    static final int NOWRAP = 2;
    double wrapLimit;
    double offset;

    public WrappingCoordinateFilter(double wrapLimit, double offset) {
        this.wrapLimit = wrapLimit;
        this.offset = offset;
    }

    public void filter(Geometry geom) {
        if (geom instanceof LineString) {
            LineString ls = (LineString)geom;
            CoordinateSequence cs = ls.getCoordinateSequence();
            int direction = this.getDisconinuityDirection(cs);
            if (direction == 2) {
                return;
            }
            this.applyOffset(cs, direction == 0 ? 0.0 : this.wrapLimit * 2.0);
        }
    }

    private int getDisconinuityDirection(CoordinateSequence cs) {
        double lastX = cs.getX(0);
        int i = 0;
        while (i < cs.size()) {
            double x = cs.getX(i);
            if (Math.abs(x - lastX) > this.wrapLimit) {
                if (x > lastX) {
                    return 1;
                }
                if (x < lastX) {
                    return 0;
                }
            }
            lastX = x;
            ++i;
        }
        return 2;
    }

    private void applyOffset(CoordinateSequence cs, double offset) {
        double lastX = cs.getX(0);
        int i = 0;
        while (i < cs.size()) {
            double x = cs.getX(i);
            double distance = Math.abs(x - lastX);
            if (distance > this.wrapLimit && distance < this.wrapLimit * 1.9) {
                offset = offset != 0.0 ? 0.0 : this.wrapLimit * 2.0;
            }
            if (offset != 0.0) {
                cs.setOrdinate(i, 0, x + offset);
            }
            lastX = x;
            ++i;
        }
    }
}

