/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelIndex;
import org.geotools.renderer.label.LabelPainter;
import org.geotools.renderer.label.LineStringCursor;
import org.geotools.renderer.label.TextStyle2DExt;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LabelCacheImpl
implements LabelCache {
    static final Logger LOGGER = Logging.getLogger(LabelCacheImpl.class);
    public double DEFAULT_PRIORITY = 1000.0;
    public static double MIN_CURVED_DELTA = 0.05235987755982988;
    protected Map<String, LabelCacheItem> labelCache = new HashMap<String, LabelCacheItem>();
    protected ArrayList<LabelCacheItem> labelCacheNonGrouped = new ArrayList();
    private List<Rectangle2D> reserved = new ArrayList<Rectangle2D>();
    static final double[] RIGHT_ANCHOR_CANDIDATES = new double[]{0.0, 0.5, 0.0, 0.0, 0.0, 1.0};
    static final double[] MID_ANCHOR_CANDIDATES = new double[]{0.5, 0.5, 0.0, 0.5, 1.0, 0.5};
    static final double[] LEFT_ANCHOR_CANDIDATES = new double[]{1.0, 0.5, 1.0, 0.0, 1.0, 1.0};
    protected LabelRenderingMode labelRenderingMode = LabelRenderingMode.STRING;
    protected SLDStyleFactory styleFactory = new SLDStyleFactory();
    boolean stop = false;
    Set<String> enabledLayers = new HashSet<String>();
    Set<String> activeLayers = new HashSet<String>();
    LineLengthComparator lineLengthComparator = new LineLengthComparator();
    GeometryFactory gf = new GeometryFactory();
    GeometryClipper clipper;
    private boolean needsOrdering = false;

    @Override
    public void enableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.add(layerId);
    }

    public LabelRenderingMode getLabelRenderingMode() {
        return this.labelRenderingMode;
    }

    public void setLabelRenderingMode(LabelRenderingMode mode) {
        this.labelRenderingMode = mode;
    }

    @Override
    public void stop() {
        this.stop = true;
        this.activeLayers.clear();
    }

    @Override
    public void start() {
        this.stop = false;
    }

    @Override
    public void clear() {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed," + " stop() or endLayer() must be called before clear is called");
        }
        this.needsOrdering = true;
        this.labelCache.clear();
        this.labelCacheNonGrouped.clear();
        this.enabledLayers.clear();
    }

    @Override
    public void clear(String layerId) {
        LabelCacheItem item;
        if (this.activeLayers.contains(layerId)) {
            throw new IllegalStateException(String.valueOf(layerId) + " is still rendering, end the layer before calling clear.");
        }
        this.needsOrdering = true;
        Iterator<LabelCacheItem> iter = this.labelCache.values().iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (!item.getLayerIds().contains(layerId)) continue;
            iter.remove();
        }
        iter = this.labelCacheNonGrouped.iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (!item.getLayerIds().contains(layerId)) continue;
            iter.remove();
        }
        this.enabledLayers.remove(layerId);
    }

    @Override
    public void disableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.remove(layerId);
    }

    @Override
    public void startLayer(String layerId) {
        this.enabledLayers.add(layerId);
        this.activeLayers.add(layerId);
    }

    public double getPriority(TextSymbolizer symbolizer, Feature feature) {
        if (symbolizer.getPriority() == null) {
            return this.DEFAULT_PRIORITY;
        }
        try {
            Double number = (Double)symbolizer.getPriority().evaluate((Object)feature, Double.class);
            return number;
        }
        catch (Exception e) {
            return this.DEFAULT_PRIORITY;
        }
    }

    public void put(String layerId, TextSymbolizer symbolizer, Feature feature, LiteShape2 shape, NumberRange scaleRange) {
        this.needsOrdering = true;
        try {
            if (symbolizer.getLabel() == null) {
                return;
            }
            String label = (String)symbolizer.getLabel().evaluate((Object)feature, String.class);
            if (label == null) {
                return;
            }
            if (label.length() == 0) {
                return;
            }
            double priorityValue = this.getPriority(symbolizer, feature);
            boolean group = this.getBooleanOption(symbolizer, "group", false);
            if (!group) {
                LabelCacheItem item = this.buildLabelCacheItem(layerId, symbolizer, feature, shape, scaleRange, label, priorityValue);
                this.labelCacheNonGrouped.add(item);
            } else {
                LabelCacheItem lci = this.labelCache.get(label);
                if (lci == null) {
                    lci = this.buildLabelCacheItem(layerId, symbolizer, feature, shape, scaleRange, label, priorityValue);
                    this.labelCache.put(label, lci);
                } else {
                    if (symbolizer.getPriority() != null && !(symbolizer.getPriority() instanceof Literal)) {
                        lci.setPriority(lci.getPriority() + priorityValue);
                    }
                    lci.getGeoms().add(shape.getGeometry());
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error adding label to the label cache", e);
        }
    }

    @Override
    public void put(Rectangle2D area) {
        this.reserved.add(area);
    }

    private LabelCacheItem buildLabelCacheItem(String layerId, TextSymbolizer symbolizer, Feature feature, LiteShape2 shape, NumberRange scaleRange, String label, double priorityValue) {
        TextStyle2D textStyle = (TextStyle2D)this.styleFactory.createStyle(feature, (Symbolizer)symbolizer, (Range)scaleRange);
        LabelCacheItem item = new LabelCacheItem(layerId, textStyle, shape, label);
        item.setPriority(priorityValue);
        item.setSpaceAround(this.getIntOption(symbolizer, "spaceAround", 0));
        item.setMaxDisplacement(this.getIntOption(symbolizer, "maxDisplacement", 0));
        item.setMinGroupDistance(this.getIntOption(symbolizer, "minGroupDistance", -1));
        item.setRepeat(this.getIntOption(symbolizer, "repeat", 0));
        item.setLabelAllGroup(this.getBooleanOption(symbolizer, "labelAllGroup", false));
        item.setRemoveGroupOverlaps(this.getBooleanOption(symbolizer, "removeOverlaps", false));
        item.setAllowOverruns(this.getBooleanOption(symbolizer, "allowOverruns", true));
        item.setFollowLineEnabled(this.getBooleanOption(symbolizer, "followLine", false));
        double maxAngleDelta = this.getDoubleOption(symbolizer, "maxAngleDelta", 22.5);
        item.setMaxAngleDelta(Math.toRadians(maxAngleDelta));
        item.setAutoWrap(this.getIntOption(symbolizer, "autoWrap", 0));
        item.setForceLeftToRightEnabled(this.getBooleanOption(symbolizer, "forceLeftToRight", true));
        item.setConflictResolutionEnabled(this.getBooleanOption(symbolizer, "conflictResolution", true));
        item.setGoodnessOfFit(this.getDoubleOption(symbolizer, "goodnessOfFit", 0.5));
        item.setPolygonAlign((TextSymbolizer.PolygonAlignOptions)this.getEnumOption(symbolizer, "polygonAlign", (Enum)TextSymbolizer.DEFAULT_POLYGONALIGN));
        item.setGraphicsResize(this.getGraphicResize(symbolizer));
        item.setGraphicMargin(this.getGraphicMargin(symbolizer));
        return item;
    }

    private Enum getEnumOption(TextSymbolizer symbolizer, String optionName, Enum defaultValue) {
        String value = symbolizer.getOption(optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            Object enumValue = Enum.valueOf(defaultValue.getDeclaringClass(), value.toUpperCase());
            return enumValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private int getIntOption(TextSymbolizer symbolizer, String optionName, int defaultValue) {
        String value = symbolizer.getOption(optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private double getDoubleOption(TextSymbolizer symbolizer, String optionName, double defaultValue) {
        String value = symbolizer.getOption(optionName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean getBooleanOption(TextSymbolizer symbolizer, String optionName, boolean defaultValue) {
        String value = symbolizer.getOption(optionName);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    private LabelCacheItem.GraphicResize getGraphicResize(TextSymbolizer symbolizer) {
        String value = (String)symbolizer.getOptions().get("graphic-resize");
        if (value == null) {
            return LabelCacheItem.GraphicResize.NONE;
        }
        return LabelCacheItem.GraphicResize.valueOf(value.toUpperCase());
    }

    private int[] getGraphicMargin(TextSymbolizer symbolizer) {
        String value = (String)symbolizer.getOptions().get("graphic-margin");
        if (value == null) {
            return null;
        }
        String[] values = value.trim().split("\\s+");
        if (values.length == 0) {
            return null;
        }
        if (values.length > 4) {
            throw new IllegalArgumentException("The graphic margin is to be specified with 1, 2 or 4 values");
        }
        int[] parsed = new int[values.length];
        int i = 0;
        while (i < parsed.length) {
            parsed[i] = Integer.parseInt(values[i]);
            ++i;
        }
        if (parsed.length == 4) {
            return parsed;
        }
        if (parsed.length == 3) {
            return new int[]{parsed[0], parsed[1], parsed[2], parsed[1]};
        }
        if (parsed.length == 2) {
            return new int[]{parsed[0], parsed[1], parsed[0], parsed[1]};
        }
        return new int[]{parsed[0], parsed[0], parsed[0], parsed[0]};
    }

    @Override
    public void endLayer(String layerId, Graphics2D graphics, Rectangle displayArea) {
        this.activeLayers.remove(layerId);
    }

    @Override
    public List<LabelCacheItem> orderedLabels() {
        List<LabelCacheItem> al = this.getActiveLabels();
        Collections.sort(al);
        Collections.reverse(al);
        return al;
    }

    private List<LabelCacheItem> getActiveLabels() {
        ArrayList<LabelCacheItem> al = new ArrayList<LabelCacheItem>();
        for (LabelCacheItem item : this.labelCache.values()) {
            if (!this.isActive(item.getLayerIds())) continue;
            al.add(item);
        }
        for (LabelCacheItem item : this.labelCacheNonGrouped) {
            if (!this.isActive(item.getLayerIds())) continue;
            al.add(item);
        }
        return al;
    }

    private boolean isActive(Set<String> layerIds) {
        for (String layerName : layerIds) {
            if (!this.enabledLayers.contains(layerName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void end(Graphics2D graphics, Rectangle displayArea) {
        Object antialiasing = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object textAntialiasing = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            if (this.labelRenderingMode != LabelRenderingMode.STRING && antialiasing == RenderingHints.VALUE_ANTIALIAS_OFF && textAntialiasing == RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.paintLabels(graphics, displayArea);
        }
        finally {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
    }

    void paintLabels(Graphics2D graphics, Rectangle displayArea) {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed," + " stop() or endLayer() must be called before end() is called");
        }
        LabelIndex glyphs = new LabelIndex();
        glyphs.reserveArea(this.reserved);
        displayArea = new Rectangle(displayArea);
        --displayArea.width;
        --displayArea.height;
        this.clipper = new GeometryClipper(new Envelope(displayArea.getMinX(), displayArea.getMaxX(), displayArea.getMinY(), displayArea.getMaxY()));
        List<LabelCacheItem> items = this.needsOrdering ? this.orderedLabels() : this.getActiveLabels();
        LabelPainter painter = new LabelPainter(graphics, this.labelRenderingMode);
        for (LabelCacheItem labelItem : items) {
            if (this.stop) {
                return;
            }
            painter.setLabel(labelItem);
            try {
                AffineTransform tempTransform = new AffineTransform();
                Geometry geom = labelItem.getGeometry();
                if (geom instanceof Point || geom instanceof MultiPoint) {
                    this.paintPointLabel(painter, tempTransform, displayArea, glyphs);
                    continue;
                }
                if (geom instanceof LineString && !(geom instanceof LinearRing) || geom instanceof MultiLineString) {
                    this.paintLineLabels(painter, tempTransform, displayArea, glyphs);
                    continue;
                }
                if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon) && !(geom instanceof LinearRing)) continue;
                this.paintPolygonLabel(painter, tempTransform, displayArea, glyphs);
            }
            catch (Exception e) {
                System.out.println("Issues painting " + labelItem.getLabel());
                e.printStackTrace();
            }
        }
    }

    private Envelope toEnvelope(Rectangle2D bounds) {
        return new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    private double goodnessOfFit(LabelPainter painter, AffineTransform transform, PreparedGeometry representativeGeom) {
        if (representativeGeom.getGeometry() instanceof Point) {
            return 1.0;
        }
        if (representativeGeom.getGeometry() instanceof LineString) {
            return 1.0;
        }
        if (representativeGeom.getGeometry() instanceof Polygon) {
            Rectangle2D glyphBounds = painter.getFullLabelBounds();
            try {
                int count = 0;
                int n = 10;
                Coordinate c = new Coordinate();
                Point pp = this.gf.createPoint(c);
                double[] gp = new double[2];
                double[] tp = new double[2];
                int i = 1;
                while (i < painter.getLineCount() + 1) {
                    gp[1] = glyphBounds.getY() + glyphBounds.getHeight() * ((double)i / (double)(painter.getLineCount() + 1));
                    int j = 1;
                    while (j < n + 1) {
                        gp[0] = glyphBounds.getX() + glyphBounds.getWidth() * ((double)j / (double)(n + 1));
                        transform.transform(gp, 0, tp, 0, 1);
                        c.x = tp[0];
                        c.y = tp[1];
                        pp.geometryChanged();
                        if (representativeGeom.contains((Geometry)pp)) {
                            ++count;
                        }
                        ++j;
                    }
                    ++i;
                }
                return (double)count / (double)(n * painter.getLineCount());
            }
            catch (Exception e) {
                Geometry g = representativeGeom.getGeometry();
                g.geometryChanged();
                Envelope ePoly = g.getEnvelopeInternal();
                Envelope eglyph = this.toEnvelope(transform.createTransformedShape(glyphBounds).getBounds2D());
                Envelope inter = this.intersection(ePoly, eglyph);
                if (inter != null) {
                    return inter.getWidth() * inter.getHeight() / (eglyph.getWidth() * eglyph.getHeight());
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private boolean paintLineLabels(LabelPainter painter, AffineTransform originalTransform, Rectangle displayArea, LabelIndex paintedBounds) throws Exception {
        LabelCacheItem labelItem = painter.getLabel();
        List<LineString> lines = this.getLineSetRepresentativeLocation(labelItem.getGeoms(), displayArea, labelItem.removeGroupOverlaps());
        if (lines == null || lines.size() == 0) {
            return false;
        }
        if (!labelItem.labelAllGroup() && lines.size() > 1) {
            lines = Collections.singletonList(lines.get(0));
        }
        Rectangle2D textBounds = painter.getFullLabelBounds();
        double step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0;
        int space = labelItem.getSpaceAround();
        int haloRadius = Math.round(labelItem.getTextStyle().getHaloFill() != null ? labelItem.getTextStyle().getHaloRadius() : 0.0f);
        int extraSpace = space + haloRadius;
        int labelDistance = labelItem.getRepeat();
        int minDistance = labelItem.getMinGroupDistance();
        LabelIndex groupLabels = new LabelIndex();
        double labelOffset = labelItem.getMaxDisplacement();
        boolean allowOverruns = labelItem.allowOverruns();
        double maxAngleDelta = labelItem.getMaxAngleDelta();
        int labelCount = 0;
        for (LineString line : lines) {
            int i;
            double[] labelPositions;
            if (labelItem.isFollowLineEnabled()) {
                line = this.decimateLineString(line, step);
            }
            double lineStringLength = line.getLength();
            if ((!allowOverruns || labelItem.isFollowLineEnabled()) && line.getLength() < textBounds.getWidth()) {
                return labelCount > 0;
            }
            if (labelDistance > 0 && (double)labelDistance < lineStringLength / 2.0) {
                labelPositions = new double[(int)(lineStringLength / (double)labelDistance)];
                labelPositions[0] = lineStringLength / 2.0;
                double offset = labelDistance;
                i = 1;
                while (i < labelPositions.length) {
                    labelPositions[i] = labelPositions[i - 1] + offset;
                    double signum = Math.signum(offset);
                    offset = -1.0 * signum * (Math.abs(offset) + (double)labelDistance);
                    ++i;
                }
            } else {
                labelPositions = new double[]{lineStringLength / 2.0};
            }
            LineStringCursor cursor = new LineStringCursor(line);
            AffineTransform tx = new AffineTransform();
            i = 0;
            while (i < labelPositions.length) {
                cursor.moveTo(labelPositions[i]);
                Coordinate centroid = cursor.getCurrentPosition();
                double currOffset = 0.0;
                boolean painted = false;
                while (Math.abs(currOffset) <= labelOffset * 2.0 && !painted) {
                    Rectangle2D labelEnvelope;
                    tx.setToIdentity();
                    double maxAngleChange = 0.0;
                    double startOrdinate = cursor.getCurrentOrdinate() - textBounds.getWidth() / 2.0;
                    double endOrdinate = cursor.getCurrentOrdinate() + textBounds.getWidth() / 2.0;
                    if (labelItem.followLineEnabled) {
                        maxAngleChange = cursor.getMaxAngleChange(startOrdinate, endOrdinate);
                        if (maxAngleChange < MIN_CURVED_DELTA) {
                            this.setupLineTransform(painter, cursor, centroid, tx, true);
                            labelEnvelope = tx.createTransformedShape(textBounds).getBounds2D();
                        } else {
                            labelEnvelope = this.getCurvedLabelBounds(cursor, startOrdinate, endOrdinate, textBounds.getHeight() / 2.0);
                        }
                    } else {
                        this.setupLineTransform(painter, cursor, centroid, tx, false);
                        labelEnvelope = tx.createTransformedShape(textBounds).getBounds2D();
                    }
                    if (!(!displayArea.contains(labelEnvelope) || labelItem.isConflictResolutionEnabled() && paintedBounds.labelsWithinDistance(labelEnvelope, extraSpace) || groupLabels.labelsWithinDistance(labelEnvelope, minDistance))) {
                        if (labelItem.isFollowLineEnabled()) {
                            if (startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength() && maxAngleChange < maxAngleDelta) {
                                if (maxAngleChange < MIN_CURVED_DELTA) {
                                    painter.paintStraightLabel(tx);
                                } else {
                                    painter.paintCurvedLabel(cursor);
                                }
                                painted = true;
                            }
                        } else if (allowOverruns || startOrdinate > 0.0 && endOrdinate <= cursor.getLineStringLength()) {
                            painter.paintStraightLabel(tx);
                            painted = true;
                        }
                    }
                    if (painted) {
                        ++labelCount;
                        groupLabels.addLabel(labelItem, labelEnvelope);
                        if (!labelItem.isConflictResolutionEnabled()) continue;
                        paintedBounds.addLabel(labelItem, labelEnvelope);
                        continue;
                    }
                    double signum = Math.signum(currOffset);
                    currOffset = signum == 0.0 ? step : -1.0 * signum * (Math.abs(currOffset) + step);
                    cursor.moveRelative(currOffset);
                    cursor.getCurrentPosition(centroid);
                }
                ++i;
            }
        }
        return labelCount > 0;
    }

    private Rectangle2D getCurvedLabelBounds(LineStringCursor cursor, double startOrdinate, double endOrdinate, double bufferSize) {
        LineString cut = cursor.getSubLineString(startOrdinate, endOrdinate);
        Envelope e = cut.getEnvelopeInternal();
        e.expandBy(bufferSize);
        return new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
    }

    private LineString decimateLineString(LineString line, double step) {
        Coordinate[] inputCoordinates = line.getCoordinates();
        ArrayList<Coordinate> simplified = new ArrayList<Coordinate>();
        Coordinate prev = inputCoordinates[0];
        simplified.add(prev);
        int i = 1;
        while (i < inputCoordinates.length) {
            Coordinate curr = inputCoordinates[i];
            if (Math.abs(curr.x - prev.x) > step || Math.abs(curr.y - prev.y) > step) {
                simplified.add(curr);
                prev = curr;
            }
            ++i;
        }
        if (simplified.size() == 1) {
            simplified.add(inputCoordinates[inputCoordinates.length - 1]);
        }
        Coordinate[] newCoords = simplified.toArray(new Coordinate[simplified.size()]);
        return line.getFactory().createLineString(newCoords);
    }

    private void setupPointTransform(AffineTransform tempTransform, Point centroid, TextStyle2D textStyle, LabelPainter painter) {
        tempTransform.translate(centroid.getX(), centroid.getY());
        double rotation = textStyle.getRotation();
        if (Double.isNaN(rotation) || Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        Rectangle2D textBounds = painter.getLabelBounds();
        double displacementX = textStyle.getAnchorX() * -textBounds.getWidth() + textStyle.getDisplacementX();
        double displacementY = textStyle.getAnchorY() * textBounds.getHeight() - textStyle.getDisplacementY() - textBounds.getHeight() + painter.getLineHeight();
        tempTransform.translate(displacementX, displacementY);
    }

    private void setupLineTransform(LabelPainter painter, LineStringCursor cursor, Coordinate centroid, AffineTransform tempTransform, boolean followLine) {
        double rotation;
        tempTransform.translate(centroid.x, centroid.y);
        TextStyle2D textStyle = painter.getLabel().getTextStyle();
        double anchorX = textStyle.getAnchorX();
        double anchorY = textStyle.getAnchorY();
        double displacementX = 0.0;
        double displacementY = 0.0;
        if (textStyle.isPointPlacement() && !followLine) {
            rotation = textStyle.getRotation();
        } else {
            rotation = painter.getLabel().isForceLeftToRightEnabled() ? cursor.getLabelOrientation() : cursor.getCurrentAngle();
            displacementY -= (double)textStyle.getPerpendicularOffset();
            anchorX = 0.5;
            anchorY = painter.getLinePlacementYAnchor();
        }
        Rectangle2D textBounds = painter.getLabelBounds();
        displacementX = anchorX * -textBounds.getWidth() + textStyle.getDisplacementX();
        displacementY += anchorY * textBounds.getHeight() - textStyle.getDisplacementY();
        if (Double.isNaN(rotation) || Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        tempTransform.translate(displacementX, displacementY);
    }

    private boolean paintPointLabel(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs) throws Exception {
        int startAngle;
        LabelCacheItem labelItem = painter.getLabel();
        Point point = this.getPointSetRepresentativeLocation(labelItem.getGeoms(), displayArea);
        if (point == null) {
            return false;
        }
        TextStyle2D ts = labelItem.getTextStyle();
        double step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0;
        double radius = Math.sqrt(ts.getDisplacementX() * ts.getDisplacementX() + ts.getDisplacementY() * ts.getDisplacementY());
        AffineTransform tx = new AffineTransform(tempTransform);
        if (this.paintPointLabelInternal(painter, tx, displayArea, glyphs, labelItem, point, ts)) {
            return true;
        }
        TextStyle2D cloned = new TextStyle2D(ts);
        int angle = startAngle = this.getClosestStandardAngle(ts.getDisplacementX(), ts.getDisplacementY());
        while (radius <= (double)labelItem.maxDisplacement) {
            int offset = 45;
            while (offset <= 360) {
                double dx = radius * Math.cos(Math.toRadians(angle));
                double dy = radius * Math.sin(Math.toRadians(angle));
                int normAngle = angle % 360;
                if (normAngle < 0) {
                    normAngle += 360;
                }
                double[] anchorPointCandidates = normAngle < 90 || normAngle > 270 ? RIGHT_ANCHOR_CANDIDATES : (normAngle > 90 && normAngle < 270 ? LEFT_ANCHOR_CANDIDATES : MID_ANCHOR_CANDIDATES);
                int i = 0;
                while (i < anchorPointCandidates.length) {
                    double ax = anchorPointCandidates[i];
                    double ay = anchorPointCandidates[i + 1];
                    cloned.setAnchorX(ax);
                    cloned.setAnchorY(ay);
                    cloned.setDisplacementX(dx);
                    cloned.setDisplacementY(dy);
                    tx = new AffineTransform(tempTransform);
                    if (this.paintPointLabelInternal(painter, tx, displayArea, glyphs, labelItem, point, cloned)) {
                        return true;
                    }
                    i += 2;
                }
                angle = angle <= startAngle ? (angle += offset) : (angle -= offset);
                offset += 45;
            }
            radius += step;
        }
        return false;
    }

    int getClosestStandardAngle(double x, double y) {
        double angle = Math.toDegrees(Math.atan2(y, x));
        return (int)Math.round(angle / 45.0) * 45;
    }

    private boolean paintPointLabelInternal(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs, LabelCacheItem labelItem, Point point, TextStyle2D textStyle) throws Exception {
        this.setupPointTransform(tempTransform, point, textStyle, painter);
        Rectangle2D transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
        if (!displayArea.contains(transformed) || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround())) {
            return false;
        }
        painter.paintStraightLabel(tempTransform);
        if (labelItem.isConflictResolutionEnabled()) {
            glyphs.addLabel(labelItem, transformed);
        }
        return true;
    }

    private boolean paintPolygonLabel(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs) throws Exception {
        double step;
        AffineTransform tx;
        Point centroid;
        LabelCacheItem labelItem = painter.getLabel();
        Polygon geom = this.getPolySetRepresentativeLocation(labelItem.getGeoms(), displayArea);
        if (geom == null) {
            return false;
        }
        try {
            centroid = geom.getCentroid();
        }
        catch (Exception e) {
            try {
                centroid = geom.getExteriorRing().getCentroid();
            }
            catch (Exception ee) {
                try {
                    centroid = geom.getFactory().createPoint(geom.getCoordinate());
                }
                catch (Exception eee) {
                    return false;
                }
            }
        }
        PreparedGeometry pg = PreparedGeometryFactory.prepare((Geometry)geom);
        if (!pg.contains((Geometry)centroid)) {
            Envelope env = geom.getEnvelopeInternal();
            double step2 = 5.0;
            int steps = (int)Math.round((env.getMaxX() - env.getMinX()) / step2);
            Coordinate c = new Coordinate();
            Point pp = this.gf.createPoint(c);
            c.y = centroid.getY();
            int max = -1;
            int maxIdx = -1;
            int containCounter = -1;
            int i = 0;
            while (i < steps) {
                c.x = env.getMinX() + step2 * (double)i;
                pp.geometryChanged();
                if (!pg.contains((Geometry)pp)) {
                    containCounter = 0;
                } else if (i == 0) {
                    containCounter = 1;
                } else if (++containCounter > max) {
                    max = containCounter;
                    maxIdx = i;
                }
                ++i;
            }
            if (maxIdx != -1) {
                int midIdx = max > 1 ? maxIdx - max / 2 : maxIdx;
                c.x = env.getMinX() + step2 * (double)midIdx;
                pp.geometryChanged();
                centroid = pp;
            } else {
                return false;
            }
        }
        TextStyle2DExt textStyle = new TextStyle2DExt(labelItem);
        if (labelItem.getMaxDisplacement() > 0) {
            textStyle.setDisplacementX(0.0);
            textStyle.setDisplacementY(0.0);
            textStyle.setAnchorX(0.5);
            textStyle.setAnchorY(0.5);
        }
        if (this.paintPolygonLabelInternal(painter, tx = new AffineTransform(tempTransform), displayArea, glyphs, labelItem, pg, centroid, textStyle)) {
            return true;
        }
        double radius = step = painter.getAscent() > 2.0 ? painter.getAscent() : 2.0;
        Coordinate c = new Coordinate(centroid.getCoordinate());
        Coordinate cc = centroid.getCoordinate();
        Point testPoint = centroid.getFactory().createPoint(c);
        while (radius < (double)labelItem.getMaxDisplacement()) {
            int angle = 0;
            while (angle < 360) {
                double dx = Math.cos(Math.toRadians(angle)) * radius;
                double dy = Math.sin(Math.toRadians(angle)) * radius;
                c.x = cc.x + dx;
                c.y = cc.y + dy;
                testPoint.geometryChanged();
                if (pg.contains((Geometry)testPoint)) {
                    textStyle.setDisplacementX(dx);
                    textStyle.setDisplacementY(dy);
                    tx = new AffineTransform(tempTransform);
                    if (this.paintPolygonLabelInternal(painter, tx, displayArea, glyphs, labelItem, pg, centroid, textStyle)) {
                        return true;
                    }
                }
                angle += 45;
            }
            radius += step;
        }
        return false;
    }

    private boolean paintPolygonLabelInternal(LabelPainter painter, AffineTransform tempTransform, Rectangle displayArea, LabelIndex glyphs, LabelCacheItem labelItem, PreparedGeometry pg, Point centroid, TextStyle2DExt textStyle) throws Exception {
        AffineTransform original = new AffineTransform(tempTransform);
        this.setupPointTransform(tempTransform, centroid, textStyle, painter);
        Rectangle2D transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
        if (!displayArea.contains(transformed) || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround()) || this.goodnessOfFit(painter, tempTransform, pg) < painter.getLabel().getGoodnessOfFit()) {
            if (textStyle.flipRotation(pg.getGeometry())) {
                tempTransform.setTransform(original);
                this.setupPointTransform(tempTransform, centroid, textStyle, painter);
                transformed = tempTransform.createTransformedShape(painter.getFullLabelBounds()).getBounds2D();
                if (!displayArea.contains(transformed) || labelItem.isConflictResolutionEnabled() && glyphs.labelsWithinDistance(transformed, labelItem.getSpaceAround()) || this.goodnessOfFit(painter, tempTransform, pg) < painter.getLabel().getGoodnessOfFit()) {
                    textStyle.flipRotation(pg.getGeometry());
                    return false;
                }
            } else {
                return false;
            }
        }
        painter.paintStraightLabel(tempTransform);
        if (labelItem.isConflictResolutionEnabled()) {
            glyphs.addLabel(labelItem, transformed);
        }
        return true;
    }

    Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    Geometry widestGeometry(GeometryCollection gc) {
        if (gc.isEmpty()) {
            return gc;
        }
        Geometry widest = gc.getGeometryN(0);
        int i = 1;
        while (i < gc.getNumGeometries()) {
            Geometry curr = gc.getGeometryN(i);
            if (curr.getEnvelopeInternal().getWidth() > widest.getEnvelopeInternal().getWidth()) {
                widest = curr;
            }
            ++i;
        }
        return widest;
    }

    Point getPointSetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea) {
        ArrayList<Point> pts = new ArrayList<Point>();
        for (Geometry g : geoms) {
            if (!(g instanceof Point) && !(g instanceof MultiPoint)) {
                g = g.getCentroid();
            }
            if (g instanceof Point) {
                Point point = (Point)g;
                if (!displayArea.contains(point.getX(), point.getY())) continue;
                pts.add(point);
                continue;
            }
            if (!(g instanceof MultiPoint)) continue;
            int t = 0;
            while (t < g.getNumGeometries()) {
                Point gg = (Point)g.getGeometryN(t);
                if (displayArea.contains(gg.getX(), gg.getY())) {
                    pts.add(gg);
                }
                ++t;
            }
        }
        if (pts.size() == 0) {
            return null;
        }
        return (Point)pts.get(0);
    }

    List<LineString> getLineSetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea, boolean removeOverlaps) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Geometry g : geoms) {
            this.accumulateLineStrings(g, lines);
        }
        if (lines.size() == 0) {
            return null;
        }
        ArrayList<Object> clippedLines = new ArrayList<LineString>();
        for (LineString ls : lines) {
            MultiLineString ll = this.clipLineString(ls);
            if (ll == null || ll.isEmpty()) continue;
            int t = 0;
            while (t < ll.getNumGeometries()) {
                clippedLines.add((LineString)ll.getGeometryN(t));
                ++t;
            }
        }
        if (removeOverlaps) {
            ArrayList<LineString> cleanedLines = new ArrayList<LineString>();
            ArrayList<Geometry> bufferCache = new ArrayList<Geometry>();
            Iterator iterator = clippedLines.iterator();
            while (iterator.hasNext()) {
                LineString ls;
                LineString g = ls = (LineString)iterator.next();
                int i = 0;
                while (i < cleanedLines.size()) {
                    LineString cleaned = (LineString)cleanedLines.get(i);
                    if (g.getEnvelopeInternal().intersects(cleaned.getEnvelopeInternal())) {
                        Geometry buffer = (Geometry)bufferCache.get(i);
                        if (buffer == null) {
                            buffer = cleaned.buffer(2.0);
                            bufferCache.set(i, buffer);
                        }
                        g = g.difference(buffer);
                    }
                    ++i;
                }
                int added = this.accumulateLineStrings((Geometry)g, cleanedLines);
                int i2 = 0;
                while (i2 < added) {
                    bufferCache.add(null);
                    ++i2;
                }
            }
            clippedLines = cleanedLines;
        }
        if (clippedLines == null || clippedLines.size() == 0) {
            return null;
        }
        List<LineString> merged = this.mergeLines(clippedLines);
        if (merged.size() == 0) {
            return null;
        }
        Collections.sort(merged, new LineLengthComparator());
        return merged;
    }

    private int accumulateLineStrings(Geometry g, List<LineString> lines) {
        if (!(g instanceof LineString || g instanceof MultiLineString || g instanceof Polygon || g instanceof MultiPolygon)) {
            return 0;
        }
        if ((g instanceof Polygon || g instanceof MultiPolygon) && !((g = g.getBoundary()) instanceof LineString) && !(g instanceof MultiLineString)) {
            return 0;
        }
        if (g instanceof LineString) {
            if (g.getLength() != 0.0) {
                lines.add((LineString)g);
                return 1;
            }
            return 0;
        }
        if (g instanceof MultiLineString) {
            int t = 0;
            while (t < g.getNumGeometries()) {
                LineString gg = (LineString)g.getGeometryN(t);
                lines.add(gg);
                ++t;
            }
            return g.getNumGeometries();
        }
        int count = 0;
        int t = 0;
        while (t < g.getNumGeometries()) {
            count += this.accumulateLineStrings(g.getGeometryN(t), lines);
            ++t;
        }
        return count;
    }

    public MultiLineString clipLineString(LineString line) {
        Geometry g;
        block5: {
            LineString clip = line;
            line.geometryChanged();
            if (this.clipper.getBounds().contains(line.getEnvelopeInternal())) {
                LineString[] lns = new LineString[]{clip};
                return line.getFactory().createMultiLineString(lns);
            }
            try {
                g = this.clipper.clip((Geometry)line, false);
                if (g != null) break block5;
                return null;
            }
            catch (Exception e) {
                return line.getFactory().createMultiLineString(new LineString[]{line});
            }
        }
        if (g instanceof LineString) {
            return line.getFactory().createMultiLineString(new LineString[]{(LineString)g});
        }
        return (MultiLineString)g;
    }

    Polygon getPolySetRepresentativeLocation(List<Geometry> geoms, Rectangle displayArea) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        Geometry displayGeometry = this.gf.toGeometry(this.toEnvelope(displayArea));
        for (Geometry g : geoms) {
            if (!(g instanceof Polygon) && !(g instanceof MultiPolygon)) continue;
            if (g instanceof Polygon) {
                polys.add((Polygon)g);
                continue;
            }
            int t = 0;
            while (t < g.getNumGeometries()) {
                Polygon gg = (Polygon)g.getGeometryN(t);
                polys.add(gg);
                ++t;
            }
        }
        if (polys.size() == 0) {
            return null;
        }
        ArrayList<Polygon> clippedPolys = new ArrayList<Polygon>();
        Envelope displayGeomEnv = displayGeometry.getEnvelopeInternal();
        for (Polygon p : polys) {
            MultiPolygon pp = this.clipPolygon(p, (Polygon)displayGeometry, displayGeomEnv);
            if (pp == null || pp.isEmpty()) continue;
            int t = 0;
            while (t < pp.getNumGeometries()) {
                clippedPolys.add((Polygon)pp.getGeometryN(t));
                ++t;
            }
        }
        if (clippedPolys.size() == 0) {
            return null;
        }
        double maxSize = -1.0;
        Polygon maxPoly = null;
        int t = 0;
        while (t < clippedPolys.size()) {
            Polygon cpoly = (Polygon)clippedPolys.get(t);
            double area = cpoly.getArea();
            if (area > maxSize) {
                maxPoly = cpoly;
                maxSize = area;
            }
            ++t;
        }
        if (maxSize > 0.0) {
            return maxPoly;
        }
        return null;
    }

    public MultiPolygon clipPolygon(Polygon poly, Polygon bbox, Envelope displayGeomEnv) {
        Polygon clip = poly;
        poly.geometryChanged();
        if (displayGeomEnv.contains(poly.getEnvelopeInternal())) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        try {
            clip = this.clipper.clip((Geometry)poly, false);
        }
        catch (Exception e) {
            clip = poly;
        }
        if (clip instanceof MultiPolygon) {
            return (MultiPolygon)clip;
        }
        if (clip instanceof Polygon) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        if (clip instanceof Point) {
            return null;
        }
        if (clip instanceof MultiPoint) {
            return null;
        }
        if (clip instanceof LineString) {
            return null;
        }
        if (clip instanceof MultiLineString) {
            return null;
        }
        if (clip == null) {
            return null;
        }
        GeometryCollection gc = (GeometryCollection)clip;
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        int t = 0;
        while (t < gc.getNumGeometries()) {
            Geometry g = gc.getGeometryN(t);
            if (g instanceof Polygon) {
                polys.add((Polygon)g);
            }
            ++t;
        }
        if (polys.size() == 0) {
            return null;
        }
        return poly.getFactory().createMultiPolygon(polys.toArray(new Polygon[1]));
    }

    private List<LineString> mergeLines(Collection<LineString> lines) {
        LineMerger lm = new LineMerger();
        lm.add(lines);
        ArrayList<LineString> merged = new ArrayList<LineString>(lm.getMergedLineStrings());
        if (merged.size() == 0) {
            return null;
        }
        if (merged.size() == 1) {
            return merged;
        }
        HashMap<Coordinate, List<LineString>> nodes = new HashMap<Coordinate, List<LineString>>(merged.size() * 2);
        for (LineString ls : merged) {
            this.putInNodeHash(ls.getCoordinateN(0), ls, nodes);
            this.putInNodeHash(ls.getCoordinateN(ls.getNumPoints() - 1), ls, nodes);
        }
        ArrayList<LineString> merged_list = new ArrayList<LineString>(merged);
        Collections.sort(merged_list, this.lineLengthComparator);
        return this.processNodes(merged_list, nodes);
    }

    public List<LineString> processNodes(List<LineString> edges, Map<Coordinate, List<LineString>> nodes) {
        ArrayList<LineString> result = new ArrayList<LineString>();
        int index = 0;
        while (index < edges.size()) {
            LineString ls2;
            LineString ls = edges.get(index);
            Coordinate key = ls.getCoordinateN(0);
            List<LineString> nodeList = nodes.get(key);
            if (nodeList == null) {
                ++index;
                continue;
            }
            if (!nodeList.contains(ls)) {
                ++index;
                continue;
            }
            this.removeFromHash(nodes, ls);
            Coordinate key2 = ls.getCoordinateN(ls.getNumPoints() - 1);
            List<LineString> nodeList2 = nodes.get(key2);
            if (nodeList.size() == 0 && nodeList2.size() == 0) {
                result.add(ls);
                ++index;
                continue;
            }
            if (nodeList.size() > 0) {
                ls2 = this.getLongest(nodeList);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            if (nodeList2.size() > 0) {
                ls2 = this.getLongest(nodeList2);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            edges.set(index, ls);
            this.putInNodeHash(ls.getCoordinateN(0), ls, nodes);
            this.putInNodeHash(ls.getCoordinateN(ls.getNumPoints() - 1), ls, nodes);
        }
        return result;
    }

    public void removeFromHash(Map<Coordinate, List<LineString>> nodes, LineString ls) {
        Coordinate key = ls.getCoordinateN(0);
        List<LineString> nodeList = nodes.get(key);
        if (nodeList != null) {
            nodeList.remove(ls);
        }
        if ((nodeList = nodes.get(key = ls.getCoordinateN(ls.getNumPoints() - 1))) != null) {
            nodeList.remove(ls);
        }
    }

    private LineString getLongest(List<LineString> al) {
        if (al.size() == 1) {
            return al.get(0);
        }
        double maxLength = -1.0;
        LineString result = null;
        for (LineString l : al) {
            if (!(l.getLength() > maxLength)) continue;
            result = l;
            maxLength = l.getLength();
        }
        return result;
    }

    private void putInNodeHash(Coordinate node, LineString ls, Map<Coordinate, List<LineString>> nodes) {
        List<LineString> nodeList = nodes.get(node);
        if (nodeList == null) {
            nodeList = new ArrayList<LineString>();
            nodeList.add(ls);
            nodes.put(node, nodeList);
        } else {
            nodeList.add(ls);
        }
    }

    private LineString reverse(LineString l) {
        List<Coordinate> clist = Arrays.asList(l.getCoordinates());
        Collections.reverse(clist);
        return l.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private LineString merge(LineString major, LineString minor) {
        Coordinate major_s = major.getCoordinateN(0);
        Coordinate major_e = major.getCoordinateN(major.getNumPoints() - 1);
        Coordinate minor_s = minor.getCoordinateN(0);
        Coordinate minor_e = minor.getCoordinateN(minor.getNumPoints() - 1);
        if (major_s.equals2D(minor_s)) {
            return this.mergeSimple(this.reverse(minor), major);
        }
        if (major_s.equals2D(minor_e)) {
            return this.mergeSimple(minor, major);
        }
        if (major_e.equals2D(minor_s)) {
            return this.mergeSimple(major, minor);
        }
        if (major_e.equals2D(minor_e)) {
            return this.mergeSimple(major, this.reverse(minor));
        }
        return null;
    }

    private LineString mergeSimple(LineString l1, LineString l2) {
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>(Arrays.asList(l1.getCoordinates()));
        clist.addAll(Arrays.asList(l2.getCoordinates()));
        return l1.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private Envelope intersection(Envelope e1, Envelope e2) {
        Envelope r = e1.intersection(e2);
        if (r.getWidth() < 0.0) {
            return null;
        }
        if (r.getHeight() < 0.0) {
            return null;
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LabelRenderingMode {
        STRING,
        OUTLINE,
        ADAPTIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LineLengthComparator
    implements Comparator<LineString> {
        private LineLengthComparator() {
        }

        @Override
        public int compare(LineString o1, LineString o2) {
            return Double.compare(o2.getLength(), o1.getLength());
        }
    }
}

