/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.BandMergeNode;
import org.geotools.renderer.lite.gridcoverage2d.BandSelectionNode;
import org.geotools.renderer.lite.gridcoverage2d.ContrastEnhancementNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.RootNode;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

class ChannelSelectionNode
extends SubchainStyleVisitorCoverageProcessingAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private static final Logger LOGGER = Logger.getLogger(ChannelSelectionNode.class.getName());

    public InternationalString getName() {
        return Vocabulary.formatInternational(4);
    }

    public ChannelSelectionNode() {
        this((Hints)null);
    }

    public ChannelSelectionNode(Hints hints) {
        super(3, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ChannelSelectionNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies a ChannelSelection following SLD 1.0 spec."));
    }

    public synchronized void visit(ChannelSelection cs) {
        SelectedChannelType[] selectedChannelTypeArray;
        List<CoverageProcessingNode> localSources = this.getSources();
        int length = localSources.size();
        if (length == 0) {
            throw new IllegalArgumentException(Errors.format(3, "ChannelSelectionNode"));
        }
        GridCoverage2D source = (GridCoverage2D)this.getSource(0).getOutput();
        ChannelSelectionNode.ensureSourceNotNull(source, this.getName().toString());
        RootNode chainSource = new RootNode(source, this.getHints());
        BandMergeNode subChainSink = new BandMergeNode(this.getHints());
        this.setSink(subChainSink);
        SelectedChannelType[] rgb = cs.getRGBChannels();
        SelectedChannelType gray = cs.getGrayChannel();
        if (rgb != null && rgb[0] != null && rgb[1] != null && rgb[2] != null && gray != null) {
            throw new IllegalArgumentException(Errors.format(9, "Both gray and rgb channel selection are valid!"));
        }
        if (gray == null) {
            selectedChannelTypeArray = rgb;
        } else {
            SelectedChannelType[] selectedChannelTypeArray2 = new SelectedChannelType[1];
            selectedChannelTypeArray = selectedChannelTypeArray2;
            selectedChannelTypeArray2[0] = gray;
        }
        SelectedChannelType[] sc = selectedChannelTypeArray;
        if (sc != null && (sc.length == 1 && sc[0] != null || sc.length == 3 && sc[0] != null && sc[1] != null && sc[2] != null)) {
            if (sc.length != 3 && sc.length != 1) {
                throw new IllegalArgumentException(Errors.format(7, sc.length));
            }
            int i = 0;
            while (i < sc.length) {
                SelectedChannelType channel = sc[i];
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Channel " + i + " was " + channel.getChannelName());
                }
                BandSelectionNode bandSelectionNode = new BandSelectionNode();
                bandSelectionNode.addSource(chainSource);
                bandSelectionNode.visit(channel);
                ContrastEnhancementNode contrastenhancementNode = new ContrastEnhancementNode();
                contrastenhancementNode.addSource(bandSelectionNode);
                bandSelectionNode.addSink(contrastenhancementNode);
                contrastenhancementNode.visit(channel != null ? channel.getContrastEnhancement() : null);
                contrastenhancementNode.addSink(subChainSink);
                subChainSink.addSource(contrastenhancementNode);
                ++i;
            }
            return;
        }
        subChainSink.addSource(chainSource);
    }
}

