/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionExtractor {
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    static List<Expression> splitCqlExpressions(String expression) {
        boolean inCqlExpression = false;
        ArrayList<Expression> result = new ArrayList<Expression>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < expression.length()) {
            char next;
            char curr = expression.charAt(i);
            boolean last = i == expression.length() - 1;
            char c = next = last ? (char)'\u0000' : expression.charAt(i + 1);
            if (curr == '\\') {
                if (last) {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                if (next == '\\') {
                    sb.append('\\');
                } else if (next == '$') {
                    sb.append('$');
                } else if (next == '}') {
                    sb.append('}');
                } else {
                    throw new IllegalArgumentException("Unescaped \\ at position " + (i + 1));
                }
                ++i;
            } else if (curr == '$') {
                if (last || next != '{') {
                    throw new IllegalArgumentException("Unescaped $ at position " + (i + 1));
                }
                if (inCqlExpression) {
                    throw new IllegalArgumentException("Already found a ${ sequence before the one at " + (i + 1));
                }
                if (sb.length() > 0) {
                    result.add((Expression)ff.literal((Object)sb.toString()));
                    sb.setLength(0);
                }
                inCqlExpression = true;
                ++i;
            } else if (curr == '}') {
                if (!inCqlExpression) {
                    throw new IllegalArgumentException("Already found a ${ sequence before the one at " + (i + 1));
                }
                if (sb.length() == 0) {
                    throw new IllegalArgumentException("Invalid empty cql expression ${} at " + (i - 1));
                }
                try {
                    result.add(ECQL.toExpression((String)sb.toString()));
                    sb.setLength(0);
                }
                catch (CQLException e) {
                    throw new IllegalArgumentException("Invalid cql expression '" + sb + "'", e);
                }
                inCqlExpression = false;
            } else {
                sb.append(curr);
            }
            ++i;
        }
        if (inCqlExpression) {
            throw new IllegalArgumentException("Unclosed CQL expression '" + sb + "'");
        }
        if (sb.length() > 0) {
            result.add((Expression)ff.literal((Object)sb.toString()));
        }
        return result;
    }

    static Expression catenateExpressions(List<Expression> expressions) {
        if (expressions == null || expressions.size() == 0) {
            throw new IllegalArgumentException("You should provide at least one expression in the list");
        }
        Expression result = expressions.get(0);
        int i = 1;
        while (i < expressions.size()) {
            result = ff.function("strConcat", new Expression[]{result, expressions.get(i)});
            ++i;
        }
        return result;
    }

    public static Expression extractCqlExpressions(String expression) {
        return ExpressionExtractor.catenateExpressions(ExpressionExtractor.splitCqlExpressions(expression));
    }
}

