package org.geotools.renderer.style;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

import org.geotools.geometry.jts.GeomCollectionIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;

public class GlyphStyle2D extends Style2D
{
	private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
	private GlyphRenderer _renderer ;
	private ExternalGraphic _externalGraphic;
	private Graphic _graphic;
	private Object _feature;
	private int _height;
	public GlyphStyle2D(GlyphRenderer renderer, Graphic graphic, ExternalGraphic externalGraphic, Object feature, int size)
	{
		_renderer = renderer;
		_graphic = graphic;
		_externalGraphic = externalGraphic;
		_feature = feature;
		_height = size;
		
	}
	
	public void render(Graphics graphics, LiteShape2 shape, double scale)
	{
		if (!isScaleInRange(scale)) return;
		
		Graphics2D g = (Graphics2D)graphics;
		//AffineTransform oldTrasnsform = g.getTransform();
		
		GeometryCollection gc;
		if (shape.getGeometry() instanceof GeometryCollection)
			gc = (GeometryCollection) shape.getGeometry();
		else {
			Geometry[] gs = new Geometry[1];
			gs[0] = shape.getGeometry();
			gc = shape.getGeometry().getFactory().createGeometryCollection(
					gs); // make a Point,Line, or Poly into a GC
		}
		GeomCollectionIterator citer = new GeomCollectionIterator(gc,
				IDENTITY_TRANSFORM, false, 1.0);

		// get the point onto the shape has to be painted
		float[] coords = new float[2];
		while (!(citer.isDone()))
		{
			citer.currentSegment(coords);
			//AffineTransform transform = new AffineTransform(oldTrasnsform);
			
			//transform.translate(coords[0], coords[1]);
			//g.setTransform(transform);
			_renderer.render(g, _graphic, _externalGraphic, _feature, _height,coords[0],coords[1]);
			//g.setTransform(oldTrasnsform);
			citer.next();
		}		
	}
}
