/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.geotools.geometry.jts.GeomCollectionIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;

public class GlyphStyle2D
extends Style2D {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private GlyphRenderer _renderer;
    private ExternalGraphic _externalGraphic;
    private Graphic _graphic;
    private Object _feature;
    private int _height;

    public GlyphStyle2D(GlyphRenderer renderer, Graphic graphic, ExternalGraphic externalGraphic, Object feature, int size) {
        this._renderer = renderer;
        this._graphic = graphic;
        this._externalGraphic = externalGraphic;
        this._feature = feature;
        this._height = size;
    }

    public void render(Graphics graphics, LiteShape2 shape, double scale) {
        GeometryCollection gc;
        if (!this.isScaleInRange(scale)) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        if (shape.getGeometry() instanceof GeometryCollection) {
            gc = (GeometryCollection)shape.getGeometry();
        } else {
            Geometry[] gs = new Geometry[]{shape.getGeometry()};
            gc = shape.getGeometry().getFactory().createGeometryCollection(gs);
        }
        GeomCollectionIterator citer = new GeomCollectionIterator(gc, IDENTITY_TRANSFORM, false, 1.0);
        float[] coords = new float[2];
        while (!citer.isDone()) {
            citer.currentSegment(coords);
            this._renderer.render(g, this._graphic, this._externalGraphic, this._feature, this._height, coords[0], coords[1]);
            citer.next();
        }
    }
}

