/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sfs;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.sfs.SFSDataStore;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFSDataStoreFactory
implements DataStoreFactorySpi {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.simplefeatureservice");
    private List<DataAccessFactory.Param> parameters = new ArrayList<DataAccessFactory.Param>();
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false);
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("Service Url", URL.class, "Root URL of the simple feature service", true);
    public static final DataAccessFactory.Param USERP = new DataAccessFactory.Param("user", String.class, "User for services protected with HTTP basic authentication", false);
    public static final DataAccessFactory.Param PASSWDP = new DataAccessFactory.Param("passwd", String.class, (InternationalString)new SimpleInternationalString("User for services protected with HTTP basic authentication"), false, null, Collections.singletonMap("isPassword", Boolean.TRUE));
    public static final DataAccessFactory.Param TIMEOUTP = new DataAccessFactory.Param("timeout", Integer.class, "Timeout for HTTP connections in seconds", false, (Object)5);

    public SFSDataStoreFactory() {
        this.parameters.add(URLP);
        this.parameters.add(NAMESPACEP);
        this.parameters.add(USERP);
        this.parameters.add(PASSWDP);
        this.parameters.add(TIMEOUTP);
    }

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters at createDataStore inside Factory");
        }
        URL url = (URL)URLP.lookUp(params);
        String namespaceURI = (String)NAMESPACEP.lookUp(params);
        String user = (String)USERP.lookUp(params);
        String password = (String)PASSWDP.lookUp(params);
        Integer timeout = (Integer)TIMEOUTP.lookUp(params);
        timeout = timeout == null ? Integer.valueOf(5000) : Integer.valueOf(timeout * 1000);
        SFSDataStore store = new SFSDataStore(url, namespaceURI, user, password, timeout);
        return store;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        return null;
    }

    public String getDisplayName() {
        return "SimpleFeatureService";
    }

    public String getDescription() {
        return "SimpleFeatureService";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return this.parameters.toArray(new DataAccessFactory.Param[0]);
    }

    public boolean canProcess(Map<String, Serializable> params) {
        if (params == null) {
            return false;
        }
        for (DataAccessFactory.Param p : this.parameters) {
            if (params.containsKey(p.key) || !p.required) continue;
            return false;
        }
        try {
            return (URL)URLP.lookUp(params) != null;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "MalFormed URL in Factory: " + e.getMessage(), e);
            return false;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

