/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileReader;

public class IndexedDbaseFileReader
extends DbaseFileReader {
    public void goTo(int recno) throws IOException, UnsupportedOperationException {
        if (this.randomAccessEnabled) {
            int newPosition = this.header.getHeaderLength() + this.header.getRecordLength() * (recno - 1);
            if (this.useMemoryMappedBuffer) {
                this.buffer.position(newPosition);
            } else {
                FileChannel fc = (FileChannel)this.channel;
                fc.position(newPosition);
                this.buffer.limit(this.buffer.capacity());
                this.buffer.position(0);
                this.fill(this.buffer, this.channel);
                this.buffer.position(0);
                this.currentOffset = newPosition;
            }
        } else {
            throw new UnsupportedOperationException("Random access not enabled!");
        }
    }

    public IndexedDbaseFileReader(ShpFiles shpFiles) throws IOException {
        this(shpFiles, false);
    }

    public IndexedDbaseFileReader(ShpFiles shpFiles, boolean useMemoryMappedBuffer) throws IOException {
        super(shpFiles, useMemoryMappedBuffer, ShapefileDataStore.DEFAULT_STRING_CHARSET);
    }

    public IndexedDbaseFileReader(ShpFiles shpFiles, boolean useMemoryMappedBuffer, Charset stringCharset) throws IOException {
        super(shpFiles, useMemoryMappedBuffer, stringCharset);
    }

    public boolean IsRandomAccessEnabled() {
        return this.randomAccessEnabled;
    }

    public static void main(String[] args) throws Exception {
        IndexedDbaseFileReader reader = new IndexedDbaseFileReader(new ShpFiles(args[0]), false);
        System.out.println(reader.getHeader());
        int r = 0;
        while (reader.hasNext()) {
            System.out.println(++r + "," + Arrays.asList(reader.readEntry()));
        }
        reader.close();
    }
}

