/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StorageFile;
import org.geotools.data.shapefile.indexed.IndexedFidWriter;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.util.logging.Logging;

public class FidIndexer {
    static Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");

    public static synchronized void generate(URL shpURL) throws IOException {
        FidIndexer.generate(new ShpFiles(shpURL));
    }

    public static void generate(ShpFiles shpFiles) throws IOException {
        LOGGER.fine("Generating fids for " + shpFiles.get(ShpFileType.SHP));
        IndexFile indexFile = null;
        StorageFile file = shpFiles.getStorageFile(ShpFileType.FIX);
        IndexedFidWriter writer = null;
        try {
            indexFile = new IndexFile(shpFiles, false);
            writer = new IndexedFidWriter(shpFiles, file);
            int i = 0;
            int j = indexFile.getRecordCount();
            while (i < j) {
                writer.next();
                ++i;
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                file.replaceOriginal();
            }
            finally {
                if (indexFile != null) {
                    indexFile.close();
                }
            }
        }
    }
}

