/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed.attribute;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.indexed.attribute.IndexRecord;
import org.geotools.resources.NIOUtilities;

public class AttributeIndexWriter {
    public static final int HEADER_SIZE = 9;
    private int cacheSize;
    private int record_size;
    private FileChannel writeChannel;
    private FileChannel currentChannel;
    private DbaseFileReader reader;
    private StreamLogging streamLogger = new StreamLogging("AttributeIndexWriter");
    private String attribute;
    private int numRecords;
    private int attributeColumn;
    private Class attributeClass;
    private char attributeType;
    private File[] tempFiles;
    private ArrayList buffer;
    private long current;
    private long position;
    private int curFile;
    private ByteBuffer writeBuffer;

    public AttributeIndexWriter(String attribute, FileChannel writeChannel, ReadableByteChannel readChannel, int cacheSize) throws IOException {
        this.writeChannel = writeChannel;
        this.attribute = attribute;
        this.cacheSize = cacheSize;
        this.reader = new DbaseFileReader(readChannel, false, ShapefileDataStore.DEFAULT_STRING_CHARSET);
        if (!this.retrieveAttributeInfos()) {
            throw new IOException("Attribute " + attribute + " not found in dbf file");
        }
        this.streamLogger.open();
        this.tempFiles = new File[this.getNumFiles()];
        this.buffer = new ArrayList(this.getCacheSize());
        this.current = 0L;
        this.curFile = 0;
    }

    public void buildIndex() throws IOException {
        while (this.hasNext()) {
            this.position = 0L;
            this.readBuffer();
            this.saveBuffer();
        }
        this.reader.close();
        this.merge();
        this.deleteTempFiles();
        this.streamLogger.close();
    }

    public int getCount() {
        return this.numRecords;
    }

    private boolean hasNext() {
        return this.reader.hasNext();
    }

    private void deleteTempFiles() {
        int i = 0;
        while (i < this.tempFiles.length) {
            if (!this.tempFiles[i].delete()) {
                this.tempFiles[i].deleteOnExit();
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void merge() throws IOException {
        in = new DataInputStream[this.tempFiles.length];
        try {
            recs = new IndexRecord[this.tempFiles.length];
            i = 0;
            while (i < this.tempFiles.length) {
                in[i] = new DataInputStream(new FileInputStream(this.tempFiles[i]));
                recs[i] = null;
                ++i;
            }
            this.currentChannel = this.writeChannel;
            this.allocateBuffers();
            this.writeBuffer.position(9);
            this.position = 0L;
            do {
                min = null;
                mpos = -1;
                streamsReady = recs.length;
                j = 0;
                while (j < recs.length) {
                    block13: {
                        if (recs[j] == null) {
                            try {
                                recs[j] = this.readRecord(in[j]);
                            }
                            catch (EOFException e) {
                                --streamsReady;
                                break block13;
                            }
                        }
                        if (min == null || min.compareTo(recs[j]) > 0) {
                            min = recs[j];
                            mpos = j;
                        }
                    }
                    ++j;
                }
                if (mpos != -1) {
                    recs[mpos] = null;
                }
                this.write(min);
            } while (streamsReady > 0);
        }
        finally {
            i = 0;
            ** while (i < in.length)
        }
lbl-1000:
        // 1 sources

        {
            if (in[i] != null) {
                in[i].close();
            }
            ++i;
            continue;
        }
lbl46:
        // 1 sources

        this.drain();
        this.writeHeader();
        this.close();
    }

    private void readBuffer() throws IOException {
        this.buffer.clear();
        int n = this.getCacheSize();
        int i = 0;
        while (this.hasNext() && i < n) {
            Comparable o = this.getAttribute();
            IndexRecord r = new IndexRecord(o, this.current + 1L);
            this.buffer.add(r);
            ++this.current;
            ++i;
        }
    }

    private void saveBuffer() throws IOException {
        RandomAccessFile raf = null;
        try {
            if (this.buffer.size() == 0) {
                return;
            }
            try {
                Collections.sort(this.buffer);
            }
            catch (OutOfMemoryError err) {
                throw new IOException(String.valueOf(err.getMessage()) + ". Try to lower memory load parameter.");
            }
            File file = File.createTempFile("attind", null);
            this.tempFiles[this.curFile++] = file;
            Iterator it = this.buffer.iterator();
            raf = new RandomAccessFile(file, "rw");
            this.currentChannel = raf.getChannel();
            this.currentChannel.lock();
            this.allocateBuffers();
            this.writeBuffer.position(0);
            while (it.hasNext()) {
                this.write((IndexRecord)it.next());
            }
        }
        finally {
            this.close();
            if (raf != null) {
                raf.close();
            }
        }
    }

    private int getNumFiles() throws IOException {
        int maxRec = this.getCacheSize();
        int n = this.numRecords / maxRec;
        return this.numRecords % maxRec == 0 ? n : n + 1;
    }

    private int getCacheSize() {
        return this.numRecords * this.record_size > this.cacheSize ? this.cacheSize / this.record_size : this.numRecords;
    }

    private Comparable getAttribute() throws IOException {
        DbaseFileReader.Row row = this.reader.readRow();
        Object o = row.read(this.attributeColumn);
        if (o instanceof Date) {
            return new Long(((Date)o).getTime());
        }
        return (Comparable)o;
    }

    private IndexRecord readRecord(DataInputStream in) throws IOException {
        Object obj = null;
        switch (this.attributeType) {
            case 'D': 
            case 'N': {
                if (this.attributeClass.isInstance(new Integer(0))) {
                    obj = new Integer(in.readInt());
                    break;
                }
                obj = new Long(in.readLong());
                break;
            }
            case 'F': {
                obj = new Double(in.readDouble());
                break;
            }
            case 'L': {
                obj = new Boolean(in.readBoolean());
                break;
            }
            default: {
                byte[] b = new byte[this.record_size - 8];
                in.read(b);
                obj = new String(b, "ISO-8859-1").trim();
            }
        }
        long id = in.readLong();
        return new IndexRecord((Comparable)obj, id);
    }

    private void write(IndexRecord r) throws IOException {
        try {
            if (r == null) {
                return;
            }
            if (this.writeBuffer == null) {
                this.allocateBuffers();
            }
            if (this.writeBuffer.remaining() < this.record_size) {
                this.drain();
            }
            switch (this.attributeType) {
                case 'D': 
                case 'N': {
                    Object obj = r.getAttribute();
                    if (this.attributeClass.isInstance(new Integer(0))) {
                        int i = obj instanceof Integer ? ((Number)obj).intValue() : (int)((Number)obj).longValue();
                        this.writeBuffer.putInt(i);
                        break;
                    }
                    long l = obj instanceof Integer ? (long)((Number)obj).intValue() : ((Number)obj).longValue();
                    this.writeBuffer.putLong(l);
                    break;
                }
                case 'F': {
                    this.writeBuffer.putDouble((Double)r.getAttribute());
                    break;
                }
                case 'L': {
                    boolean b = (Boolean)r.getAttribute();
                    this.writeBuffer.put((byte)(b ? 1 : 0));
                    break;
                }
                default: {
                    byte[] btemp = r.getAttribute().toString().getBytes("ISO-8859-1");
                    byte[] bres = new byte[this.record_size - 8];
                    int i = 0;
                    while (i < bres.length) {
                        bres[i] = i < btemp.length ? btemp[i] : (byte)0;
                        ++i;
                    }
                    this.writeBuffer.put(bres);
                }
            }
            this.writeBuffer.putLong(r.getFeatureID());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void writeHeader() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(9);
        buf.put((byte)this.attributeType);
        buf.putInt(this.record_size);
        buf.putInt(this.numRecords);
        buf.flip();
        this.writeChannel.write(buf, 0L);
    }

    private void allocateBuffers() throws IOException {
        this.writeBuffer = NIOUtilities.allocate((int)(9 + this.record_size * 1024));
    }

    private void drain() throws IOException {
        if (this.writeBuffer == null) {
            return;
        }
        this.writeBuffer.flip();
        int written = 0;
        while (this.writeBuffer.remaining() > 0) {
            written += this.currentChannel.write(this.writeBuffer, this.position);
        }
        this.position += (long)written;
        this.writeBuffer.flip().limit(this.writeBuffer.capacity());
    }

    private boolean retrieveAttributeInfos() {
        DbaseFileHeader header = this.reader.getHeader();
        int i = 0;
        while (i < header.getNumFields()) {
            if (header.getFieldName(i).equals(this.attribute)) {
                this.attributeColumn = i;
                this.attributeClass = header.getFieldClass(i);
                this.numRecords = header.getNumRecords();
                this.attributeType = header.getFieldType(i);
                switch (this.attributeType) {
                    case 'C': {
                        this.record_size = header.getFieldLength(i);
                        break;
                    }
                    case 'N': {
                        if (this.attributeClass.isInstance(new Integer(0))) {
                            this.record_size = 4;
                            break;
                        }
                        this.record_size = 8;
                        break;
                    }
                    case 'F': {
                        this.record_size = 8;
                        break;
                    }
                    case 'D': {
                        this.record_size = 8;
                        break;
                    }
                    case 'L': {
                        this.record_size = 1;
                        break;
                    }
                    default: {
                        this.record_size = header.getFieldLength(i);
                    }
                }
                this.record_size += 8;
                return true;
            }
            ++i;
        }
        return false;
    }

    private void close() throws IOException {
        try {
            this.drain();
        }
        finally {
            if (this.writeBuffer != null && this.writeBuffer instanceof MappedByteBuffer) {
                NIOUtilities.clean((ByteBuffer)this.writeBuffer);
            }
            if (this.currentChannel != null && this.currentChannel.isOpen()) {
                this.currentChannel.close();
            }
        }
    }
}

