/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.util.logging.Logging;

public class PolygonHandler
implements ShapeHandler {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    GeometryFactory geometryFactory;
    final ShapeType shapeType;

    public PolygonHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.POLYGON;
        this.geometryFactory = gf;
    }

    public PolygonHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.POLYGON && type != ShapeType.POLYGONM && type != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        int t = pointList.length - 1;
        while (t >= 0) {
            Coordinate p = pointList[t];
            if (testPoint.x == p.x && testPoint.y == p.y && (testPoint.z == p.z || testPoint.z != testPoint.z)) {
                return true;
            }
            --t;
        }
        return false;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getLength(Object geometry) {
        int length;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        int nrings = 0;
        int t = 0;
        while (t < multi.getNumGeometries()) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
            ++t;
        }
        int npoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.POLYGONZ) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16 + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGONM) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGON) {
            length = 44 + 4 * nrings + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.shapeType);
        }
        return length;
    }

    public Object read(ByteBuffer buffer, ShapeType type, boolean flatFeature) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int dimensions = this.shapeType == ShapeType.POLYGONZ && !flatFeature ? 3 : 2;
        int[] partOffsets = new int[numParts];
        int i = 0;
        while (i < numParts) {
            partOffsets[i] = buffer.getInt();
            ++i;
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        CoordinateSequence coords = this.readCoordinates(buffer, numPoints, dimensions);
        int offset = 0;
        int part = 0;
        while (part < numParts) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            int close = 0;
            if (coords.getOrdinate(start, 0) != coords.getOrdinate(finish - 1, 0) || coords.getOrdinate(start, 1) != coords.getOrdinate(finish - 1, 1)) {
                close = 1;
            }
            if (dimensions == 3 && coords.getOrdinate(start, 2) != coords.getOrdinate(finish - 1, 2)) {
                close = 1;
            }
            CoordinateSequence csRing = this.geometryFactory.getCoordinateSequenceFactory().create(length + close, dimensions);
            int i2 = 0;
            while (i2 < length) {
                csRing.setOrdinate(i2, 0, coords.getOrdinate(offset, 0));
                csRing.setOrdinate(i2, 1, coords.getOrdinate(offset, 1));
                if (dimensions == 3) {
                    csRing.setOrdinate(i2, 2, coords.getOrdinate(offset, 2));
                }
                ++offset;
                ++i2;
            }
            if (close == 1) {
                csRing.setOrdinate(length, 0, coords.getOrdinate(start, 0));
                csRing.setOrdinate(length, 1, coords.getOrdinate(start, 1));
                if (dimensions == 3) {
                    csRing.setOrdinate(length, 2, coords.getOrdinate(start, 2));
                }
            }
            if (csRing.size() == 0 || csRing.size() > 3) {
                LinearRing ring = this.geometryFactory.createLinearRing(csRing);
                if (CoordinateSequences.isCCW((CoordinateSequence)csRing)) {
                    holes.add(ring);
                } else {
                    shells.add(ring);
                }
            }
            ++part;
        }
        if (shells.size() == 1) {
            return this.createMulti((LinearRing)shells.get(0), holes);
        }
        if (holes.size() == 1 && shells.size() == 0) {
            return this.createMulti((LinearRing)holes.get(0));
        }
        ArrayList holesForShells = this.assignHolesToShells(shells, holes);
        Geometry g = this.buildGeometries(shells, holes, holesForShells);
        return g;
    }

    private CoordinateSequence readCoordinates(ByteBuffer buffer, int numPoints, int dimensions) {
        CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(numPoints, dimensions);
        DoubleBuffer dbuffer = buffer.asDoubleBuffer();
        double[] ordinates = new double[numPoints * 2];
        dbuffer.get(ordinates);
        int t = 0;
        while (t < numPoints) {
            cs.setOrdinate(t, 0, ordinates[t * 2]);
            cs.setOrdinate(t, 1, ordinates[t * 2 + 1]);
            ++t;
        }
        if (dimensions > 2) {
            dbuffer.position(dbuffer.position() + 2);
            dbuffer.get(ordinates, 0, numPoints);
            t = 0;
            while (t < numPoints) {
                cs.setOrdinate(t, 2, ordinates[t]);
                ++t;
            }
        }
        return cs;
    }

    private Geometry buildGeometries(List shells, List holes, List holesForShells) {
        Polygon[] polygons = shells.size() > 0 ? new Polygon[shells.size()] : new Polygon[holes.size()];
        int i = 0;
        while (i < shells.size()) {
            polygons[i] = this.geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
            ++i;
        }
        if (shells.size() == 0) {
            i = 0;
            int ii = holes.size();
            while (i < ii) {
                LinearRing hole = (LinearRing)holes.get(i);
                polygons[i] = this.geometryFactory.createPolygon(hole, null);
                ++i;
            }
        }
        MultiPolygon g = this.geometryFactory.createMultiPolygon(polygons);
        return g;
    }

    ArrayList assignHolesToShells(ArrayList shells, ArrayList holes) {
        ArrayList holesForShells = new ArrayList(shells.size());
        int i = 0;
        while (i < shells.size()) {
            holesForShells.add(new ArrayList());
            ++i;
        }
        i = 0;
        while (i < holes.size()) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            int j = 0;
            while (j < shells.size()) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (isContained && (minShell == null || minEnv.contains(tryEnv))) {
                    minShell = tryRing;
                }
                ++j;
            }
            if (minShell == null) {
                shells.add(testRing);
                holesForShells.add(new ArrayList());
            } else {
                ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
            }
            ++i;
        }
        return holesForShells;
    }

    private MultiPolygon createMulti(LinearRing single) {
        return this.createMulti(single, Collections.EMPTY_LIST);
    }

    private MultiPolygon createMulti(LinearRing single, List holes) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(single, holes.toArray(new LinearRing[holes.size()]))});
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        int seqSize;
        CoordinateSequence coords;
        int ringN;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        ArrayList<CoordinateSequence> allCoords = new ArrayList<CoordinateSequence>();
        int t = 0;
        while (t < multi.getNumGeometries()) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            allCoords.add(p.getExteriorRing().getCoordinateSequence());
            ringN = 0;
            while (ringN < p.getNumInteriorRing()) {
                allCoords.add(p.getInteriorRingN(ringN).getCoordinateSequence());
                ++ringN;
            }
            ++t;
        }
        CoordinateSequence[] coordinates = allCoords.toArray(new CoordinateSequence[allCoords.size()]);
        int nrings = coordinates.length;
        int npoints = multi.getNumPoints();
        buffer.putInt(nrings);
        buffer.putInt(npoints);
        int count = 0;
        int t2 = 0;
        while (t2 < nrings) {
            buffer.putInt(count);
            count += coordinates[t2].size();
            ++t2;
        }
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        ringN = 0;
        while (ringN < nrings) {
            coords = coordinates[ringN];
            JTSUtilities.zMinMax(coords, zExtreame);
            seqSize = coords.size();
            int coordN = 0;
            while (coordN < seqSize) {
                buffer.putDouble(coords.getOrdinate(coordN, 0));
                buffer.putDouble(coords.getOrdinate(coordN, 1));
                ++coordN;
            }
            ++ringN;
        }
        if (this.shapeType == ShapeType.POLYGONZ) {
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            ringN = 0;
            while (ringN < nrings) {
                coords = coordinates[ringN];
                seqSize = coords.size();
                int coordN = 0;
                while (coordN < seqSize) {
                    double z = coords.getOrdinate(coordN, 2);
                    if (Double.isNaN(z)) {
                        buffer.putDouble(0.0);
                    } else {
                        buffer.putDouble(z);
                    }
                    ++coordN;
                }
                ++ringN;
            }
        }
        if (this.shapeType == ShapeType.POLYGONM || this.shapeType == ShapeType.POLYGONZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            int t3 = 0;
            while (t3 < npoints) {
                buffer.putDouble(-1.0E41);
                ++t3;
            }
        }
    }
}

