/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.resources.NIOUtilities;

public class DbaseFileWriter {
    private DbaseFileHeader header;
    private FieldFormatter formatter;
    WritableByteChannel channel;
    private ByteBuffer buffer;
    private final Number NULL_NUMBER = new Integer(0);
    private final String NULL_STRING = "";
    private final Date NULL_DATE = new Date();
    private StreamLogging streamLogger = new StreamLogging("Dbase File Writer");
    private Charset charset;

    public DbaseFileWriter(DbaseFileHeader header, WritableByteChannel out) throws IOException {
        this(header, out, null);
    }

    public DbaseFileWriter(DbaseFileHeader header, WritableByteChannel out, Charset charset) throws IOException {
        header.writeHeader(out);
        this.header = header;
        this.channel = out;
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.formatter = new FieldFormatter(this.charset);
        this.streamLogger.open();
        this.init();
    }

    private void init() throws IOException {
        this.buffer = ByteBuffer.allocateDirect(this.header.getRecordLength());
    }

    private void write() throws IOException {
        this.buffer.position(0);
        int r = this.buffer.remaining();
        while ((r -= this.channel.write(this.buffer)) > 0) {
        }
    }

    public void write(Object[] record) throws IOException, DbaseFileException {
        if (record.length != this.header.getNumFields()) {
            throw new DbaseFileException("Wrong number of fields " + record.length + " expected " + this.header.getNumFields());
        }
        this.buffer.position(0);
        this.buffer.put((byte)32);
        for (int i = 0; i < this.header.getNumFields(); ++i) {
            String fieldString = this.fieldString(record[i], i);
            if (this.header.getFieldLength(i) != fieldString.getBytes(this.charset.name()).length) {
                this.buffer.put(new byte[this.header.getFieldLength(i)]);
                continue;
            }
            this.buffer.put(fieldString.getBytes(this.charset.name()));
        }
        this.write();
    }

    private String fieldString(Object obj, int col) {
        String o;
        int fieldLen = this.header.getFieldLength(col);
        switch (this.header.getFieldType(col)) {
            case 'C': 
            case 'c': {
                o = this.formatter.getFieldString(fieldLen, obj == null ? "" : obj.toString());
                break;
            }
            case 'L': 
            case 'l': {
                o = obj == null ? "F" : (obj == Boolean.TRUE ? "T" : "F");
                break;
            }
            case 'G': 
            case 'M': {
                o = this.formatter.getFieldString(fieldLen, obj == null ? "" : obj.toString());
                break;
            }
            case 'N': 
            case 'n': {
                if (this.header.getFieldDecimalCount(col) == 0) {
                    o = this.formatter.getFieldString(fieldLen, 0, (Number)(obj == null ? this.NULL_NUMBER : obj));
                    break;
                }
            }
            case 'F': 
            case 'f': {
                o = this.formatter.getFieldString(fieldLen, this.header.getFieldDecimalCount(col), (Number)(obj == null ? this.NULL_NUMBER : obj));
                break;
            }
            case 'D': 
            case 'd': {
                o = this.formatter.getFieldString((Date)(obj == null ? this.NULL_DATE : obj));
                break;
            }
            default: {
                throw new RuntimeException("Unknown type " + this.header.getFieldType(col));
            }
        }
        return o;
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer instanceof MappedByteBuffer) {
            NIOUtilities.clean((ByteBuffer)this.buffer);
        }
        this.buffer = null;
        this.channel = null;
        this.formatter = null;
    }

    public static class FieldFormatter {
        private StringBuffer buffer = new StringBuffer(255);
        private NumberFormat numFormat = NumberFormat.getNumberInstance(Locale.US);
        private Calendar calendar = Calendar.getInstance(Locale.US);
        private String emptyString;
        private static final int MAXCHARS = 255;
        private Charset charset;

        public FieldFormatter(Charset charset) {
            this.numFormat.setGroupingUsed(false);
            StringBuffer sb = new StringBuffer(255);
            sb.setLength(255);
            for (int i = 0; i < 255; ++i) {
                sb.setCharAt(i, ' ');
            }
            this.charset = charset;
            this.emptyString = sb.toString();
        }

        public String getFieldString(int size, String s) {
            try {
                this.buffer.replace(0, size, this.emptyString);
                this.buffer.setLength(size);
                int maxSize = size;
                if (s != null) {
                    this.buffer.replace(0, size, s);
                    int currentBytes = s.substring(0, Math.min(size, s.length())).getBytes(this.charset.name()).length;
                    if (currentBytes > size) {
                        char[] c = new char[1];
                        int index = size - 1;
                        while (currentBytes > size) {
                            c[0] = this.buffer.charAt(index);
                            String string = new String(c);
                            this.buffer.deleteCharAt(index);
                            currentBytes -= string.getBytes().length;
                            --maxSize;
                            --index;
                        }
                    } else if (s.length() < size) {
                        maxSize = size - (currentBytes - s.length());
                        for (int i = s.length(); i < size; ++i) {
                            this.buffer.append(' ');
                        }
                    }
                }
                this.buffer.setLength(maxSize);
                return this.buffer.toString();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This error should never occurr", e);
            }
        }

        public String getFieldString(Date d) {
            if (d != null) {
                this.buffer.delete(0, this.buffer.length());
                this.calendar.setTime(d);
                int year = this.calendar.get(1);
                int month = this.calendar.get(2) + 1;
                int day = this.calendar.get(5);
                if (year < 1000) {
                    if (year >= 100) {
                        this.buffer.append("0");
                    } else if (year >= 10) {
                        this.buffer.append("00");
                    } else {
                        this.buffer.append("000");
                    }
                }
                this.buffer.append(year);
                if (month < 10) {
                    this.buffer.append("0");
                }
                this.buffer.append(month);
                if (day < 10) {
                    this.buffer.append("0");
                }
                this.buffer.append(day);
            } else {
                this.buffer.setLength(8);
                this.buffer.replace(0, 8, this.emptyString);
            }
            this.buffer.setLength(8);
            return this.buffer.toString();
        }

        public String getFieldString(int size, int decimalPlaces, Number n) {
            int diff;
            this.buffer.delete(0, this.buffer.length());
            if (n != null) {
                this.numFormat.setMaximumFractionDigits(decimalPlaces);
                this.numFormat.setMinimumFractionDigits(decimalPlaces);
                this.numFormat.format(n, this.buffer, new FieldPosition(0));
            }
            if ((diff = size - this.buffer.length()) >= 0) {
                while (diff-- > 0) {
                    this.buffer.insert(0, ' ');
                }
            } else {
                this.buffer.setLength(size);
            }
            return this.buffer.toString();
        }
    }
}

