/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.Calendar;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.resources.NIOUtilities;

public class DbaseFileReader
implements FileReader {
    DbaseFileHeader header;
    ByteBuffer buffer;
    ReadableByteChannel channel;
    byte[] bytes;
    char[] fieldTypes;
    int[] fieldLengths;
    int[] fieldOffsets;
    int cnt = 1;
    Row row;
    protected boolean useMemoryMappedBuffer;
    protected boolean randomAccessEnabled;
    protected int currentOffset = 0;
    private final StreamLogging streamLogger = new StreamLogging("Dbase File Reader");
    private Charset stringCharset;
    private boolean oneBytePerChar;

    public DbaseFileReader(ShpFiles shapefileFiles, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        ReadableByteChannel dbfChannel = shapefileFiles.getReadChannel(ShpFileType.DBF, this);
        this.init(dbfChannel, useMemoryMappedBuffer, charset);
    }

    public DbaseFileReader(ReadableByteChannel readChannel, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        this.init(readChannel, useMemoryMappedBuffer, charset);
    }

    private void init(ReadableByteChannel dbfChannel, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        this.channel = dbfChannel;
        this.stringCharset = charset;
        this.useMemoryMappedBuffer = useMemoryMappedBuffer;
        this.randomAccessEnabled = this.channel instanceof FileChannel;
        this.streamLogger.open();
        this.header = new DbaseFileHeader();
        this.header.readHeader(this.channel);
        if (this.channel instanceof FileChannel && this.useMemoryMappedBuffer) {
            FileChannel fc = (FileChannel)this.channel;
            this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            this.buffer.position((int)fc.position());
            this.currentOffset = 0;
        } else {
            this.useMemoryMappedBuffer = false;
            int size = 8192;
            size = this.header.getRecordLength() > size ? this.header.getRecordLength() : size;
            this.buffer = ByteBuffer.allocateDirect(size);
            this.fill(this.buffer, this.channel);
            this.buffer.flip();
            this.currentOffset = this.header.getHeaderLength();
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fieldTypes = new char[this.header.getNumFields()];
        this.fieldLengths = new int[this.header.getNumFields()];
        this.fieldOffsets = new int[this.header.getNumFields()];
        int ii = this.header.getNumFields();
        for (int i = 0; i < ii; ++i) {
            this.fieldTypes[i] = this.header.getFieldType(i);
            this.fieldLengths[i] = this.header.getFieldLength(i);
            if (i <= 0) continue;
            this.fieldOffsets[i] = this.fieldOffsets[i - 1] + this.header.getFieldLength(i - 1);
        }
        this.bytes = new byte[this.header.getRecordLength() - 1];
        CharsetEncoder encoder = this.stringCharset.newEncoder();
        this.oneBytePerChar = encoder.maxBytesPerChar() == 1.0f;
        this.row = new Row();
    }

    protected int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private void bufferCheck() throws IOException {
        if (!this.buffer.isReadOnly() && this.buffer.remaining() < this.header.getRecordLength()) {
            this.currentOffset += this.buffer.position();
            this.buffer.compact();
            this.fill(this.buffer, this.channel);
            this.buffer.position(0);
        }
    }

    public DbaseFileHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer instanceof MappedByteBuffer) {
            NIOUtilities.clean((ByteBuffer)this.buffer);
        }
        this.buffer = null;
        this.channel = null;
        this.bytes = null;
        this.header = null;
        this.row = null;
    }

    public boolean hasNext() {
        return this.cnt < this.header.getNumRecords() + 1;
    }

    public Object[] readEntry() throws IOException {
        return this.readEntry(new Object[this.header.getNumFields()]);
    }

    public Row readRow() throws IOException {
        this.read();
        return this.row;
    }

    public void skip() throws IOException {
        boolean foundRecord = false;
        while (!foundRecord) {
            this.bufferCheck();
            char tempDeleted = (char)this.buffer.get();
            this.buffer.position(this.buffer.position() + this.header.getRecordLength() - 1);
            if (tempDeleted == '*') continue;
            foundRecord = true;
        }
    }

    public Object[] readEntry(Object[] entry, int offset) throws IOException {
        if (entry.length - offset < this.header.getNumFields()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.read();
        int numFields = this.header.getNumFields();
        for (int j = 0; j < numFields; ++j) {
            entry[j + offset] = this.readObject(this.fieldOffsets[j], j);
        }
        return entry;
    }

    public Object readField(int fieldNum) throws IOException {
        return this.readObject(this.fieldOffsets[fieldNum], fieldNum);
    }

    public void transferTo(DbaseFileWriter writer) throws IOException {
        this.bufferCheck();
        this.buffer.limit(this.buffer.position() + this.header.getRecordLength());
        writer.channel.write(this.buffer);
        this.buffer.limit(this.buffer.capacity());
        ++this.cnt;
    }

    public void read() throws IOException {
        boolean foundRecord = false;
        while (!foundRecord) {
            this.bufferCheck();
            char deleted = (char)this.buffer.get();
            if (deleted == '*') continue;
            this.buffer.limit(this.buffer.position() + this.header.getRecordLength() - 1);
            this.buffer.get(this.bytes);
            this.buffer.limit(this.buffer.capacity());
            foundRecord = true;
        }
        ++this.cnt;
    }

    public Object[] readEntry(Object[] entry) throws IOException {
        return this.readEntry(entry, 0);
    }

    private Object readObject(int fieldOffset, int fieldNum) throws IOException {
        char type = this.fieldTypes[fieldNum];
        int fieldLen = this.fieldLengths[fieldNum];
        Object object = null;
        if (fieldLen > 0) {
            block4 : switch (type) {
                case 'L': 
                case 'l': {
                    char c = (char)this.bytes[fieldOffset];
                    switch (c) {
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            object = Boolean.TRUE;
                            break block4;
                        }
                        case 'F': 
                        case 'N': 
                        case 'f': 
                        case 'n': {
                            object = Boolean.FALSE;
                            break block4;
                        }
                    }
                    throw new IOException("Unknown logical value : '" + c + "'");
                }
                case 'C': 
                case 'c': {
                    if (this.oneBytePerChar) {
                        object = this.fastParse(this.bytes, fieldOffset, fieldLen).trim();
                        break;
                    }
                    object = new String(this.bytes, fieldOffset, fieldLen, this.stringCharset.name()).trim();
                    break;
                }
                case 'D': 
                case 'd': {
                    try {
                        String tempString = this.fastParse(this.bytes, fieldOffset, 4);
                        int tempYear = Integer.parseInt(tempString);
                        tempString = this.fastParse(this.bytes, fieldOffset + 4, 2);
                        int tempMonth = Integer.parseInt(tempString) - 1;
                        tempString = this.fastParse(this.bytes, fieldOffset + 6, 2);
                        int tempDay = Integer.parseInt(tempString);
                        Calendar cal = Calendar.getInstance();
                        cal.clear();
                        cal.set(1, tempYear);
                        cal.set(2, tempMonth);
                        cal.set(5, tempDay);
                        object = cal.getTime();
                    }
                    catch (NumberFormatException nfe) {}
                    break;
                }
                case 'N': 
                case 'n': {
                    String string = this.fastParse(this.bytes, fieldOffset, fieldLen);
                    try {
                        Class clazz = this.header.getFieldClass(fieldNum);
                        if (clazz == Integer.class) {
                            object = Integer.parseInt(string);
                            break;
                        }
                        if (clazz == Long.class) {
                            object = Long.parseLong(string);
                            break;
                        }
                    }
                    catch (NumberFormatException e) {
                        try {
                            object = Long.parseLong(string);
                            break;
                        }
                        catch (NumberFormatException e2) {
                            // empty catch block
                        }
                    }
                }
                case 'F': 
                case 'f': {
                    try {
                        object = Double.parseDouble(this.fastParse(this.bytes, fieldOffset, fieldLen));
                    }
                    catch (NumberFormatException e) {
                        object = new Double(0.0);
                    }
                    break;
                }
                default: {
                    throw new IOException("Invalid field type : " + type);
                }
            }
        }
        return object;
    }

    String fastParse(byte[] bytes, int fieldOffset, int fieldLen) {
        char[] chars = new char[fieldLen];
        for (int i = 0; i < fieldLen; ++i) {
            chars[i] = (char)(0xFF & bytes[fieldOffset + i]);
        }
        return new String(chars);
    }

    public static void main(String[] args) throws Exception {
        DbaseFileReader reader = new DbaseFileReader(new ShpFiles(args[0]), false, Charset.forName("ISO-8859-1"));
        System.out.println(reader.getHeader());
        int r = 0;
        while (reader.hasNext()) {
            System.out.println(++r + "," + Arrays.asList(reader.readEntry()));
        }
        reader.close();
    }

    public String id() {
        return this.getClass().getName();
    }

    public final class Row {
        public Object read(int column) throws IOException {
            int offset = DbaseFileReader.this.fieldOffsets[column];
            return DbaseFileReader.this.readObject(offset, column);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer("DBF Row - ");
            for (int i = 0; i < DbaseFileReader.this.header.getNumFields(); ++i) {
                ret.append(DbaseFileReader.this.header.getFieldName(i)).append(": \"");
                try {
                    ret.append(this.read(i));
                }
                catch (IOException ioe) {
                    ret.append(ioe.getMessage());
                }
                ret.append("\" ");
            }
            return ret.toString();
        }
    }
}

