/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.geotools.swing.TextReporterListener;

public class JTextReporter
extends JDialog {
    public static final int DEFAULT_ROWS = 20;
    public static final int DEFAULT_COLS = 50;
    private int rows;
    private int cols;
    private JTextArea textArea;
    private File cwd;
    private static String lineSep = System.getProperty("line.separator");
    private List<TextReporterListener> listeners;

    public JTextReporter(String title) throws HeadlessException {
        this(title, -1, -1);
    }

    public JTextReporter(String title, int rows, int cols) throws HeadlessException {
        this.setTitle(title);
        this.rows = rows >= 0 ? rows : 20;
        this.cols = cols >= 0 ? cols : 50;
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setModal(false);
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                for (TextReporterListener listener : JTextReporter.this.listeners) {
                    listener.onReporterClosed(e);
                }
            }
        });
        this.listeners = new ArrayList<TextReporterListener>();
    }

    public boolean addListener(TextReporterListener listener) {
        return this.listeners.add(listener);
    }

    public synchronized void append(final String text) {
        if (EventQueue.isDispatchThread()) {
            this.doAppend(text);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JTextReporter.this.doAppend(text);
                    }
                });
            }
            catch (InterruptedException intEx) {
                return;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void initComponents() {
        this.textArea = new JTextArea(this.rows, this.cols);
        this.textArea.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setAutoscrolls(true);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        MigLayout layout = new MigLayout("wrap 1", "[grow]", "[grow][]");
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add((Component)scrollPane, "grow");
        JPanel btnPanel = new JPanel();
        JButton saveBtn = new JButton("Save");
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextReporter.this.saveReport();
            }
        });
        btnPanel.add(saveBtn);
        JButton clearBtn = new JButton("Clear");
        clearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextReporter.this.clearReport();
            }
        });
        btnPanel.add(clearBtn);
        panel.add(btnPanel);
        this.getContentPane().add(panel);
        this.pack();
    }

    private void doAppend(String text) {
        int startLine = this.textArea.getLineCount();
        this.textArea.append(text);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        for (TextReporterListener listener : this.listeners) {
            listener.onReporterUpdated(startLine);
        }
    }

    private void clearReport() {
        int len = this.textArea.getDocument().getLength();
        if (len > 0) {
            try {
                this.textArea.getDocument().remove(0, len);
            }
            catch (BadLocationException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void saveReport() {
        int len = this.textArea.getDocument().getLength();
        if (len > 0) {
            Writer writer = null;
            try {
                try {
                    File file = this.getFile();
                    if (file != null) {
                        writer = new BufferedWriter(new FileWriter(file));
                        int line = 0;
                        while (line < this.textArea.getLineCount()) {
                            int end;
                            int start = this.textArea.getLineStartOffset(line);
                            String lineText = this.textArea.getText(start, (end = this.textArea.getLineEndOffset(line)) - start);
                            if (lineText.endsWith("\n")) {
                                lineText = lineText.substring(0, lineText.length() - 1);
                            }
                            writer.write(lineText);
                            writer.write(lineSep);
                            ++line;
                        }
                    }
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException("Internal error getting report to save");
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private File getFile() {
        JFileChooser chooser = new JFileChooser(this.cwd);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "All files";
            }
        });
        if (chooser.showSaveDialog(this) != 0) {
            return null;
        }
        this.cwd = chooser.getCurrentDirectory();
        return chooser.getSelectedFile();
    }
}

