/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.geotools.resources.SwingUtilities;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.swing.ExceptionMonitor;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class ProgressWindow
implements ProgressListener {
    private static final int WIDTH = 360;
    private static final int HEIGHT = 140;
    private static final int WARNING_HEIGHT = 120;
    private static final int HMARGIN = 12;
    private static final int VMARGIN = 9;
    private static final int WARNING_MARGIN = 8;
    private final Component window;
    private final JComponent content;
    private final JProgressBar progressBar;
    private final JLabel description;
    private final JButton cancel;
    private JComponent warningArea;
    private String lastSource;
    private volatile boolean canceled;

    public ProgressWindow(Component parent) {
        Dimension parentSize;
        Vocabulary resources = Vocabulary.getResources((Locale)(parent != null ? parent.getLocale() : null));
        String title = resources.getString(176);
        JDesktopPane desktop = JOptionPane.getDesktopPaneForComponent(parent);
        if (desktop != null) {
            JInternalFrame frame = new JInternalFrame(title);
            this.window = frame;
            this.content = new JPanel();
            parentSize = desktop.getSize();
            frame.setContentPane(this.content);
            frame.setDefaultCloseOperation(1);
            desktop.add((Component)frame, JLayeredPane.PALETTE_LAYER);
        } else {
            JDialog dialog = new JDialog(null, title);
            this.window = dialog;
            this.content = (JComponent)dialog.getContentPane();
            parentSize = Toolkit.getDefaultToolkit().getScreenSize();
            dialog.setDefaultCloseOperation(1);
            dialog.setResizable(false);
        }
        this.window.setBounds((parentSize.width - 360) / 2, (parentSize.height - 140) / 2, 360, 140);
        this.description = new JLabel();
        this.description.setHorizontalAlignment(0);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 9, 6, 9), this.progressBar.getBorder()));
        this.cancel = new JButton(resources.getString(13));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProgressWindow.this.setCanceled(true);
            }
        });
        Box cancelBox = Box.createHorizontalBox();
        cancelBox.add(Box.createGlue());
        cancelBox.add(this.cancel);
        cancelBox.add(Box.createGlue());
        cancelBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(9, 12, 9, 12), BorderFactory.createEtchedBorder()));
        panel.add(this.description);
        panel.add(this.progressBar);
        this.content.setLayout(new BorderLayout());
        this.content.add((Component)panel, "North");
        this.content.add((Component)cancelBox, "South");
    }

    private String getString(int key) {
        return Vocabulary.getResources((Locale)this.window.getLocale()).getString(key);
    }

    public String getTitle() {
        return (String)this.get(1);
    }

    public void setTitle(String title) {
        if (title == null) {
            title = this.getString(176);
        }
        this.set(1, title);
    }

    public String getDescription() {
        return (String)this.get(2);
    }

    public void setDescription(String description) {
        this.set(2, description);
    }

    public void started() {
        this.call(5);
    }

    public void progress(float percent) {
        int p = (int)percent;
        if (p < 0) {
            p = 0;
        }
        if (p > 100) {
            p = 100;
        }
        this.set(3, new Integer(p));
    }

    public float getProgress() {
        BoundedRangeModel model = this.progressBar.getModel();
        float progress = model.getValue() - model.getMinimum();
        float limit = model.getMaximum();
        return progress / limit;
    }

    public void complete() {
        this.call(6);
    }

    public void dispose() {
        this.call(7);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean stop) {
        this.canceled = stop;
    }

    public synchronized void warningOccurred(String source, String margin, String warning) {
        int i;
        StringBuffer buffer = new StringBuffer(warning.length() + 16);
        if (!source.equals(this.lastSource)) {
            this.lastSource = source;
            if (this.warningArea != null) {
                buffer.append('\n');
            }
            buffer.append(source != null ? source : this.getString(232));
            buffer.append('\n');
        }
        int wm = 8;
        if (margin != null && (margin = ProgressWindow.trim(margin)).length() != 0) {
            wm -= margin.length() + 3;
            i = 0;
            while (i < wm) {
                buffer.append(' ');
                ++i;
            }
            buffer.append('(');
            buffer.append(margin);
            buffer.append(')');
            wm = 1;
        }
        i = 0;
        while (i < wm) {
            buffer.append(' ');
            ++i;
        }
        buffer.append(warning);
        if (buffer.charAt(buffer.length() - 1) != '\n') {
            buffer.append('\n');
        }
        this.set(4, buffer.toString());
    }

    public void exceptionOccurred(Throwable exception) {
        ExceptionMonitor.show(this.window, exception);
    }

    private static String trim(String margin) {
        margin = margin.trim();
        int lower = 0;
        int upper = margin.length();
        while (lower < upper && margin.charAt(lower + 0) == '(') {
            ++lower;
        }
        while (lower < upper && margin.charAt(upper - 1) == ')') {
            --upper;
        }
        return margin.substring(lower, upper);
    }

    private Object get(int task) {
        Caller caller = new Caller(-task);
        SwingUtilities.invokeAndWait((Runnable)caller);
        return caller.value;
    }

    private void set(int task, Object value) {
        Caller caller = new Caller(task);
        caller.value = value;
        EventQueue.invokeLater(caller);
    }

    private void call(int task) {
        EventQueue.invokeLater(new Caller(task));
    }

    public void setTask(InternationalString task) {
        this.setDescription(task.toString());
    }

    public InternationalString getTask() {
        return new SimpleInternationalString(this.getDescription());
    }

    private class Caller
    implements Runnable {
        public static final int TITLE = 1;
        public static final int LABEL = 2;
        public static final int PROGRESS = 3;
        public static final int WARNING = 4;
        public static final int STARTED = 5;
        public static final int COMPLETE = 6;
        public static final int DISPOSE = 7;
        private final int task;
        public Object value;

        public Caller(int task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BoundedRangeModel model = ProgressWindow.this.progressBar.getModel();
            switch (this.task) {
                case -2: {
                    this.value = ProgressWindow.this.description.getText();
                    return;
                }
                case 2: {
                    ProgressWindow.this.description.setText((String)this.value);
                    return;
                }
                case 3: {
                    model.setValue((Integer)this.value);
                    ProgressWindow.this.progressBar.setIndeterminate(false);
                    return;
                }
                case 5: {
                    model.setRangeProperties(0, 1, 0, 100, false);
                    ProgressWindow.this.window.setVisible(true);
                    break;
                }
                case 6: {
                    model.setRangeProperties(100, 1, 0, 100, false);
                    ProgressWindow.this.window.setVisible(ProgressWindow.this.warningArea != null);
                    ProgressWindow.this.cancel.setEnabled(false);
                }
            }
            ProgressWindow progressWindow = ProgressWindow.this;
            synchronized (progressWindow) {
                JTextArea warningArea;
                Container window;
                if (ProgressWindow.this.window instanceof JDialog) {
                    window = (JDialog)ProgressWindow.this.window;
                    switch (this.task) {
                        case -1: {
                            this.value = ((Dialog)window).getTitle();
                            return;
                        }
                        case 1: {
                            ((Dialog)window).setTitle((String)this.value);
                            return;
                        }
                        case 5: {
                            ((JDialog)window).setDefaultCloseOperation(0);
                            return;
                        }
                        case 6: {
                            ((JDialog)window).setDefaultCloseOperation(1);
                            return;
                        }
                        case 7: {
                            ((JDialog)window).setDefaultCloseOperation(2);
                            if (ProgressWindow.this.warningArea == null || !window.isVisible()) {
                                ((Window)window).dispose();
                            }
                            return;
                        }
                    }
                } else {
                    window = (JInternalFrame)ProgressWindow.this.window;
                    switch (this.task) {
                        case -1: {
                            this.value = ((JInternalFrame)window).getTitle();
                            return;
                        }
                        case 1: {
                            ((JInternalFrame)window).setTitle((String)this.value);
                            return;
                        }
                        case 5: {
                            ((JInternalFrame)window).setClosable(false);
                            return;
                        }
                        case 6: {
                            ((JInternalFrame)window).setClosable(true);
                            return;
                        }
                        case 7: {
                            ((JInternalFrame)window).setDefaultCloseOperation(2);
                            if (ProgressWindow.this.warningArea == null || !window.isVisible()) {
                                ((JInternalFrame)window).dispose();
                            }
                            return;
                        }
                    }
                }
                if (ProgressWindow.this.warningArea == null) {
                    warningArea = new JTextArea();
                    JScrollPane scroll = new JScrollPane(warningArea);
                    JPanel namedArea = new JPanel(new BorderLayout());
                    ProgressWindow.this.warningArea = warningArea;
                    warningArea.setFont(Font.getFont("Monospaced"));
                    warningArea.setEditable(false);
                    namedArea.setBorder(BorderFactory.createEmptyBorder(0, 12, 9, 12));
                    namedArea.add((Component)new JLabel(ProgressWindow.this.getString(242)), "North");
                    namedArea.add((Component)scroll, "Center");
                    ProgressWindow.this.content.add((Component)namedArea, "Center");
                    if (ProgressWindow.this.window instanceof JDialog) {
                        JDialog window2 = (JDialog)ProgressWindow.this.window;
                        window2.setResizable(true);
                    } else {
                        JInternalFrame window3 = (JInternalFrame)ProgressWindow.this.window;
                        window3.setResizable(true);
                    }
                    ProgressWindow.this.window.setSize(360, 260);
                    ProgressWindow.this.window.setVisible(true);
                }
                warningArea = (JTextArea)ProgressWindow.this.warningArea;
                warningArea.append((String)this.value);
            }
        }
    }
}

