/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.control;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.geotools.swing.control.IntegerDocument;
import org.geotools.swing.control.JValueField;
import org.geotools.swing.control.ValueChangedEvent;

public class JIntegerField
extends JValueField {
    private IntegerDocument document;
    private boolean fireEvents;

    public JIntegerField() {
        this(0, true);
    }

    public JIntegerField(boolean allowsNegative) {
        this(0, allowsNegative);
    }

    public JIntegerField(int value) {
        this(value, true);
    }

    public JIntegerField(int value, boolean allowNegative) {
        this.document = new IntegerDocument(allowNegative);
        this.setDocument(this.document);
        this.setValue(value);
        this.document.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (JIntegerField.this.fireEvents) {
                    ValueChangedEvent<Integer> ev = new ValueChangedEvent<Integer>(JIntegerField.this, JIntegerField.this.document.getValue());
                    JIntegerField.this.fireValueChangedEvent(ev);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (JIntegerField.this.fireEvents) {
                    ValueChangedEvent<Integer> ev = new ValueChangedEvent<Integer>(JIntegerField.this, JIntegerField.this.document.getValue());
                    JIntegerField.this.fireValueChangedEvent(ev);
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public int getValue() {
        return this.document.getValue();
    }

    public void setValue(int value) {
        this.setValue(value, true);
    }

    public void setValue(int value, boolean publishEvent) {
        this.fireEvents = publishEvent;
        if (!this.document.getAllowsNegative() && value < 0) {
            throw new IllegalArgumentException(String.format("Negative value (%d) but text field set to only allow positive values", value));
        }
        this.setText(String.valueOf(value));
        this.fireEvents = true;
    }
}

