/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.control.JIntegerField;
import org.geotools.swing.control.ValueChangedEvent;
import org.geotools.swing.control.ValueChangedListener;
import org.geotools.swing.dialog.JFileImageChooser;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;

public class JMapImageDialog
extends JDialog {
    public static final int DEFAULT_IMAGE_WIDTH = 1000;
    private static final int WIDTH_FIELD = 0;
    private static final int HEIGHT_FIELD = 1;
    private JTextField fileField;
    private JComboBox scaleCombo;
    private JIntegerField widthField;
    private JIntegerField heightField;
    private boolean completed;
    private Rectangle imageSize;
    private boolean setByScale;
    private File selectedFile;
    private double heightToWidth;
    private ReferencedEnvelope mapBounds;
    private final int XAXIS;
    private final int YAXIS;

    public JMapImageDialog(ReferencedEnvelope mapBounds) {
        AxisDirection dir;
        CoordinateSystem cs;
        if (mapBounds == null) {
            throw new IllegalArgumentException("The mapBounds argument cannot be null");
        }
        this.setTitle("Output image size");
        this.setModal(true);
        this.setResizable(false);
        this.mapBounds = new ReferencedEnvelope(mapBounds);
        CoordinateReferenceSystem crs = mapBounds.getCoordinateReferenceSystem();
        boolean swapAxes = false;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null && ((dir = cs.getAxis(0).getDirection().absolute()).equals((Object)AxisDirection.NORTH) || dir.equals((Object)AxisDirection.DISPLAY_UP))) {
            swapAxes = true;
        }
        this.XAXIS = swapAxes ? 1 : 0;
        this.YAXIS = swapAxes ? 0 : 1;
        this.initComponents();
        this.initValues();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Rectangle getImageSize() {
        return this.imageSize;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public String getImageFormat() {
        int dot;
        String format = null;
        if (this.selectedFile != null && (dot = this.selectedFile.getName().lastIndexOf(46)) > 0) {
            format = this.selectedFile.getName().substring(dot + 1);
        }
        return format;
    }

    private void initComponents() {
        MigLayout layout = new MigLayout("", "[][]30px[][]", "[][][][]30px[]");
        JPanel panel = new JPanel((LayoutManager)layout);
        JLabel fileLabel = new JLabel("File");
        panel.add((Component)fileLabel, "cell 0 0");
        this.fileField = new JTextField(20);
        panel.add((Component)this.fileField, "cell 1 0 3 1");
        JButton browseBtn = new JButton("Browse...");
        browseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapImageDialog.this.brosweFile();
            }
        });
        panel.add((Component)browseBtn, "cell 1 0");
        int[] baseScales = new int[]{10, 25, 50};
        int[] multipliers = new int[]{1, 10, 100, 1000, 10000, 100000};
        Object[] scales = new Object[baseScales.length * multipliers.length];
        int i = 0;
        int k = 0;
        while (i < multipliers.length) {
            int j = 0;
            while (j < baseScales.length) {
                scales[k] = new Integer(multipliers[i] * baseScales[j]);
                ++j;
                ++k;
            }
            ++i;
        }
        final JCheckBox scaleCheck = new JCheckBox("Set by pixel scale", false);
        panel.add((Component)scaleCheck, "cell 1 1");
        JLabel scaleLabel = new JLabel("Scale 1:");
        panel.add((Component)scaleLabel, "cell 1 2, gapbefore indent");
        DefaultComboBoxModel<Object> scaleModel = new DefaultComboBoxModel<Object>(scales);
        this.scaleCombo = new JComboBox<Object>(scaleModel);
        this.scaleCombo.setEditable(true);
        this.scaleCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapImageDialog.this.onScaleChange();
            }
        });
        panel.add((Component)this.scaleCombo, "cell 1 2");
        JCheckBox sizeCheck = new JCheckBox("Set by image size", true);
        panel.add((Component)sizeCheck, "cell 2 1 2 1");
        JLabel widthLabel = new JLabel("width");
        panel.add((Component)widthLabel, "cell 2 2, gapbefore indent");
        this.widthField = new JIntegerField();
        this.widthField.addValueChangedListener(new ValueChangedListener(){

            public void onValueChanged(ValueChangedEvent ev) {
                JMapImageDialog.this.onImageSizeChange(0);
            }
        });
        int fieldWidth = this.widthField.getFontMetrics(this.widthField.getFont()).stringWidth("00000000");
        panel.add((Component)this.widthField, String.format("cell 3 2, w %d!", fieldWidth));
        JLabel heightLabel = new JLabel("height");
        panel.add((Component)heightLabel, "cell 2 3, gapbefore indent");
        this.heightField = new JIntegerField();
        this.heightField.addValueChangedListener(new ValueChangedListener(){

            public void onValueChanged(ValueChangedEvent ev) {
                JMapImageDialog.this.onImageSizeChange(1);
            }
        });
        panel.add((Component)this.heightField, String.format("cell 3 3, w %d!", fieldWidth));
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapImageDialog.this.completed = true;
                JMapImageDialog.this.setVisible(false);
            }
        });
        panel.add((Component)okBtn, "cell 1 4 3 1");
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapImageDialog.this.completed = false;
                JMapImageDialog.this.setVisible(false);
            }
        });
        panel.add((Component)cancelBtn, "cell 1 4");
        ButtonGroup grp = new ButtonGroup();
        grp.add(scaleCheck);
        grp.add(sizeCheck);
        scaleCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapImageDialog.this.setByScale = scaleCheck.isSelected();
                JMapImageDialog.this.enableItems();
            }
        });
        sizeCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapImageDialog.this.setByScale = scaleCheck.isSelected();
                JMapImageDialog.this.enableItems();
            }
        });
        this.setByScale = scaleCheck.isSelected();
        this.enableItems();
        this.getContentPane().add(panel);
        this.pack();
    }

    private void enableItems() {
        this.scaleCombo.setEnabled(this.setByScale);
        this.widthField.setEnabled(!this.setByScale);
        this.heightField.setEnabled(!this.setByScale);
    }

    private void initValues() {
        this.heightToWidth = this.mapBounds.getSpan(this.YAXIS) / this.mapBounds.getSpan(this.XAXIS);
        this.imageSize = new Rectangle();
        this.widthField.setValue(1000);
    }

    private void onImageSizeChange(int controlModified) {
        switch (controlModified) {
            case 0: {
                this.imageSize.width = this.widthField.getValue();
                this.imageSize.height = (int)Math.round((double)this.imageSize.width * this.heightToWidth);
                this.heightField.setValue(this.imageSize.height, false);
                break;
            }
            case 1: {
                this.imageSize.height = this.heightField.getValue();
                this.imageSize.width = (int)Math.round((double)this.imageSize.height / this.heightToWidth);
                this.widthField.setValue(this.imageSize.width, false);
            }
        }
        int scaleDenominator = 0;
        if (this.imageSize.width > 0) {
            scaleDenominator = (int)Math.round(this.mapBounds.getSpan(this.XAXIS) / (double)this.imageSize.width);
        }
        this.scaleCombo.getEditor().setItem(scaleDenominator);
    }

    private void onScaleChange() {
        int scaleDenominator = ((Number)this.scaleCombo.getEditor().getItem()).intValue();
        if (scaleDenominator > 0) {
            this.imageSize.width = (int)(this.mapBounds.getSpan(this.XAXIS) / (double)scaleDenominator);
            this.imageSize.height = (int)(this.mapBounds.getSpan(this.YAXIS) / (double)scaleDenominator);
        } else {
            this.imageSize.height = 0;
            this.imageSize.width = 0;
        }
        this.widthField.setValue(this.imageSize.width, false);
        this.heightField.setValue(this.imageSize.height, false);
    }

    private void brosweFile() {
        File file = JFileImageChooser.showSaveFile(this);
        if (file != null) {
            this.selectedFile = file;
            this.fileField.setText(file.getAbsolutePath());
        }
    }

    public static void main(String[] args) {
        ReferencedEnvelope bounds = new ReferencedEnvelope(0.0, 10000.0, 0.0, 20000.0, null);
        JMapImageDialog dialog = new JMapImageDialog(bounds);
        dialog.setVisible(true);
        dialog.dispose();
    }
}

