/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.swing.tool.InfoToolHelper;
import org.geotools.swing.utils.MapLayerUtils;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayerHelper
extends InfoToolHelper<List<Number>> {
    protected final WeakReference<GridCoverage2D> covRef;

    public GridLayerHelper(MapContext context, MapLayer layer) {
        super(context, null);
        Object rasterSource = null;
        try {
            FeatureIterator iter = layer.getFeatureSource().getFeatures().features();
            String gridAttrName = MapLayerUtils.getGridAttributeName(layer);
            rasterSource = iter.next().getProperty(gridAttrName).getValue();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to access raster feature data", ex);
        }
        GridCoverage2D cov = null;
        try {
            cov = AbstractGridCoverage2DReader.class.isAssignableFrom(rasterSource.getClass()) ? ((AbstractGridCoverage2DReader)rasterSource).read(null) : (GridCoverage2D)rasterSource;
            this.covRef = new WeakReference<GridCoverage2D>(cov);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        this.setCRS(cov.getCoordinateReferenceSystem());
    }

    @Override
    public List<Number> getInfo(DirectPosition2D pos, Object ... params) throws Exception {
        Object objArray;
        Number[] bandValues;
        DirectPosition2D trPos;
        GridCoverage2D cov;
        ReferencedEnvelope env;
        ArrayList<Number> list = new ArrayList<Number>();
        if (this.isValid() && (env = new ReferencedEnvelope((Envelope)(cov = (GridCoverage2D)this.covRef.get()).getEnvelope2D())).contains((DirectPosition)(trPos = this.getTransformed(pos))) && (bandValues = this.asNumberArray(objArray = cov.evaluate((DirectPosition)trPos))) != null) {
            Number[] numberArray = bandValues;
            int n = bandValues.length;
            int n2 = 0;
            while (n2 < n) {
                Number value = numberArray[n2];
                list.add(value);
                ++n2;
            }
        }
        return list;
    }

    @Override
    public boolean isValid() {
        return this.getMapContext() != null && this.covRef != null && this.covRef.get() != null;
    }

    private Number[] asNumberArray(Object objArray) {
        Number[] numbers;
        block5: {
            block7: {
                block6: {
                    block4: {
                        numbers = null;
                        if (!(objArray instanceof byte[])) break block4;
                        byte[] values = (byte[])objArray;
                        numbers = new Number[values.length];
                        int i = 0;
                        while (i < values.length) {
                            numbers[i] = values[i] & 0xFF;
                            ++i;
                        }
                        break block5;
                    }
                    if (!(objArray instanceof int[])) break block6;
                    int[] values = (int[])objArray;
                    numbers = new Number[values.length];
                    int i = 0;
                    while (i < values.length) {
                        numbers[i] = values[i];
                        ++i;
                    }
                    break block5;
                }
                if (!(objArray instanceof float[])) break block7;
                float[] values = (float[])objArray;
                numbers = new Number[values.length];
                int i = 0;
                while (i < values.length) {
                    numbers[i] = Float.valueOf(values[i]);
                    ++i;
                }
                break block5;
            }
            if (!(objArray instanceof double[])) break block5;
            double[] values = (double[])objArray;
            numbers = new Number[values.length];
            int i = 0;
            while (i < values.length) {
                numbers[i] = values[i];
                ++i;
            }
        }
        return numbers;
    }

    private DirectPosition2D getTransformed(DirectPosition2D pos) {
        if (this.isTransformRequired()) {
            MathTransform tr = this.getTransform();
            if (tr == null) {
                throw new IllegalStateException("MathTransform should not be null");
            }
            try {
                return (DirectPosition2D)tr.transform((DirectPosition)pos, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return pos;
    }
}

