/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.map.MapContext;
import org.geotools.referencing.CRS;
import org.geotools.swing.tool.VectorLayerHelper;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfoToolHelper<T> {
    private static final Logger LOGGER = Logger.getLogger(VectorLayerHelper.class.getName());
    private final WeakReference<MapContext> contextRef;
    private CoordinateReferenceSystem dataCRS;
    private boolean transformRequired;
    private boolean transformFailed;
    private MathTransform transform;

    protected InfoToolHelper(MapContext context, CoordinateReferenceSystem dataCRS) {
        this.contextRef = new WeakReference<MapContext>(context);
        this.setCRS(dataCRS);
    }

    public abstract T getInfo(DirectPosition2D var1, Object ... var2) throws Exception;

    public abstract boolean isValid();

    public MapContext getMapContext() {
        return this.contextRef != null ? (MapContext)this.contextRef.get() : null;
    }

    protected boolean isTransformRequired() {
        return this.transformRequired;
    }

    public MathTransform getTransform() {
        if (this.transform == null && !this.transformFailed && this.dataCRS != null) {
            MapContext context = this.getMapContext();
            if (context == null) {
                throw new IllegalStateException("map context should not be null");
            }
            CoordinateReferenceSystem contextCRS = context.getCoordinateReferenceSystem();
            try {
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)contextCRS, (CoordinateReferenceSystem)this.dataCRS, (boolean)true);
            }
            catch (Exception ex) {
                LOGGER.warning("Can't transform map context to map layer CRS");
                this.transformFailed = true;
            }
        }
        return this.transform;
    }

    protected void setCRS(CoordinateReferenceSystem crs) {
        this.dataCRS = crs;
        MapContext context = this.getMapContext();
        if (context == null) {
            throw new IllegalStateException("map context should not be null");
        }
        CoordinateReferenceSystem contextCRS = context.getCoordinateReferenceSystem();
        this.transformRequired = false;
        if (contextCRS != null && crs != null && !CRS.equalsIgnoreMetadata((Object)contextCRS, (Object)this.dataCRS)) {
            this.transformRequired = true;
        }
    }
}

