/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wizard;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.geotools.data.Parameter;
import org.geotools.swing.wizard.JWizard;
import org.geotools.swing.wizard.ParamField;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGeometryField
extends ParamField {
    private JTextArea text;

    public JGeometryField(Parameter<?> parameter) {
        super(parameter);
    }

    @Override
    public JComponent doLayout() {
        this.text = new JTextArea(40, 3);
        this.text.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JGeometryField.this.validate();
            }
        });
        this.text.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane(this.text, 22, 31);
        scroll.setPreferredSize(new Dimension(400, 80));
        return scroll;
    }

    @Override
    public Object getValue() {
        WKTReader reader = new WKTReader();
        String wkt = this.text.getText();
        if (wkt.length() == 0) {
            return null;
        }
        try {
            return reader.read(wkt);
        }
        catch (Throwable eek) {
            return null;
        }
    }

    int getD() {
        try {
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.parameter.metadata.get("crs");
            if (crs == null) {
            }
            return crs.getCoordinateSystem().getDimension();
        }
        finally {
            return 2;
        }
    }

    @Override
    public void setValue(Object value) {
        Geometry geom = (Geometry)value;
        WKTWriter writer = new WKTWriter(this.getD());
        String wkt = writer.write(geom);
        this.text.setText(wkt);
    }

    @Override
    public void addListener(JWizard.Controller controller) {
        this.text.addKeyListener(controller);
    }

    @Override
    public void removeListener(JWizard.Controller controller) {
        this.text.addKeyListener(controller);
    }

    @Override
    public boolean validate() {
        Geometry geom;
        block4: {
            WKTReader reader = new WKTReader();
            String wkt = this.text.getText();
            if (wkt.length() == 0) {
                return true;
            }
            try {
                geom = reader.read(wkt);
                if (!this.parameter.type.isInstance(geom)) break block4;
                this.text.setToolTipText(null);
                this.text.setForeground(Color.BLACK);
                return true;
            }
            catch (Throwable eek) {
                this.text.setToolTipText(eek.getLocalizedMessage());
                this.text.setForeground(Color.RED);
                return false;
            }
        }
        this.text.setToolTipText("Could not use " + geom.getClass() + " as " + this.parameter.type);
        this.text.setForeground(Color.RED);
        return false;
    }
}

