/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.swing.JMapPane;
import org.geotools.swing.event.MapMouseAdapter;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.event.MapPaneAdapter;
import org.geotools.swing.event.MapPaneEvent;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class StatusBar
extends JPanel {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    public static final int NUM_SPACES = 3;
    public static final int COORDS_SPACE = 0;
    public static final int BOUNDS_SPACE = 1;
    public static final int CRS_SPACE = 2;
    private JMapPane mapPane;
    private MapContext context;
    private MapMouseListener mouseListener;
    private MapPaneAdapter mapPaneListener;
    private JLabel[] spaces;

    public StatusBar() {
        this((JMapPane)null);
    }

    public StatusBar(JMapPane pane) {
        this.createListeners();
        this.init();
        if (pane != null) {
            this.setMapPane(pane);
        }
    }

    public void setMapPane(JMapPane newPane) {
        if (newPane == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        if (this.mapPane != newPane) {
            if (this.mapPane != null) {
                this.mapPane.removeMouseListener(this.mouseListener);
            }
            newPane.addMouseListener(this.mouseListener);
            newPane.addMapPaneListener(this.mapPaneListener);
            this.context = newPane.getMapContext();
            this.mapPane = newPane;
        }
    }

    public void clearCoords() {
        this.spaces[0].setText("");
    }

    public void clearBounds() {
        this.spaces[1].setText("");
    }

    public void displayCoords(DirectPosition2D mapPos) {
        if (mapPos != null) {
            this.spaces[0].setText(String.format("  %.2f %.2f", mapPos.x, mapPos.y));
        }
    }

    public void displayBounds(Envelope bounds) {
        if (bounds != null) {
            this.spaces[1].setText(String.format("Min:%.2f %.2f Span:%.2f %.2f", bounds.getMinimum(0), bounds.getMinimum(1), bounds.getSpan(0), bounds.getSpan(1)));
        }
    }

    public void displayCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            this.spaces[2].setText("Undefined");
        } else {
            this.spaces[2].setText(crs.getName().toString());
        }
    }

    private void init() {
        MigLayout lm = new MigLayout("insets 0");
        this.setLayout((LayoutManager)lm);
        this.spaces = new JLabel[3];
        Font font = Font.decode("Courier-12");
        int fontH = this.getFontMetrics(font).getHeight();
        this.spaces[0] = new JLabel();
        this.spaces[0].setFont(font);
        Rectangle2D rect = this.getFontMetrics(font).getStringBounds("  00000000.000 00000000.000", this.spaces[0].getGraphics());
        String constraint = String.format("width %d!, height %d!", (int)rect.getWidth() + 10, (int)rect.getHeight() + 6);
        this.add((Component)this.spaces[0], constraint);
        this.spaces[1] = new JLabel();
        this.spaces[1].setFont(font);
        rect = this.getFontMetrics(font).getStringBounds("Min: 00000000.000 00000000.000 Span: 00000000.000 00000000.000", this.spaces[0].getGraphics());
        constraint = String.format("width %d!, height %d!", (int)rect.getWidth() + 10, (int)rect.getHeight() + 6);
        this.add((Component)this.spaces[1], constraint);
        this.spaces[2] = new JLabel();
        this.spaces[2].setFont(font);
        rect = this.getFontMetrics(font).getStringBounds("The name of a CRS might be this long", this.spaces[0].getGraphics());
        constraint = String.format("width %d!, height %d!", (int)rect.getWidth() + 20, (int)rect.getHeight() + 6);
        this.add((Component)this.spaces[2], constraint);
    }

    private void createListeners() {
        this.mouseListener = new MapMouseAdapter(){

            public void onMouseMoved(MapMouseEvent ev) {
                StatusBar.this.displayCoords(ev.getMapPosition());
            }

            public void onMouseExited(MapMouseEvent ev) {
                StatusBar.this.clearCoords();
            }
        };
        this.mapPaneListener = new MapPaneAdapter(){

            public void onDisplayAreaChanged(MapPaneEvent ev) {
                ReferencedEnvelope env = StatusBar.this.mapPane.getDisplayArea();
                if (env != null) {
                    StatusBar.this.displayBounds((Envelope)env);
                    StatusBar.this.displayCRS(env.getCoordinateReferenceSystem());
                }
            }

            public void onResized(MapPaneEvent ev) {
                ReferencedEnvelope env = StatusBar.this.mapPane.getDisplayArea();
                if (env != null) {
                    StatusBar.this.displayBounds((Envelope)env);
                    StatusBar.this.displayCRS(env.getCoordinateReferenceSystem());
                }
            }
        };
    }
}

