/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.tool.AbstractZoomTool;
import org.opengis.geometry.Envelope;

public class ZoomOutTool
extends AbstractZoomTool {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    public static final String TOOL_NAME = stringRes.getString("tool_name_zoom_out");
    public static final String TOOL_TIP = stringRes.getString("tool_tip_zoom_out");
    public static final String CURSOR_IMAGE = "/org/geotools/swing/icons/mActionZoomOut.png";
    public static final Point CURSOR_HOTSPOT = new Point(14, 9);
    public static final String ICON_IMAGE = "/org/geotools/swing/icons/mActionZoomOut.png";
    private Cursor cursor;

    public ZoomOutTool() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageIcon imgIcon = new ImageIcon(this.getClass().getResource("/org/geotools/swing/icons/mActionZoomOut.png"));
        this.cursor = tk.createCustomCursor(imgIcon.getImage(), CURSOR_HOTSPOT, TOOL_NAME);
    }

    public void onMouseClicked(MapMouseEvent ev) {
        Rectangle paneArea = this.getMapPane().getVisibleRect();
        DirectPosition2D mapPos = ev.getMapPosition();
        double scale = this.getMapPane().getWorldToScreenTransform().getScaleX();
        double newScale = scale / this.zoom;
        DirectPosition2D corner = new DirectPosition2D(mapPos.getX() - 0.5 * paneArea.getWidth() / newScale, mapPos.getY() + 0.5 * paneArea.getHeight() / newScale);
        Envelope2D newMapArea = new Envelope2D();
        newMapArea.setFrameFromCenter((Point2D)mapPos, (Point2D)corner);
        this.getMapPane().setDisplayArea((Envelope)newMapArea);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public boolean drawDragBox() {
        return false;
    }
}

