/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.TerralibDataStore;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.util.TerralibAttributeHelper;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class TerralibFeatureTypeAdapter
implements SimpleFeatureType {
    private SimpleFeatureType _targetFeatureType;
    private static Logger _logger = Logger.getLogger(TerralibFeatureTypeAdapter.class);

    public TerralibFeatureTypeAdapter(SimpleFeatureType featureType) {
        if (featureType == null) {
            throw new NullArgumentException("featureType");
        }
        this._targetFeatureType = this.buildCompatibleFeatureType(featureType);
    }

    protected SimpleFeatureType buildCompatibleFeatureType(SimpleFeatureType featureType) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(featureType.getName());
        builder.setCRS(featureType.getCoordinateReferenceSystem());
        builder.setDescription(featureType.getDescription());
        int attrIndex = 0;
        for (AttributeDescriptor a : featureType.getAttributeDescriptors()) {
            String name = this.fixAttributeName(a.getLocalName(), attrIndex);
            TypeAttributeMap type = TypeAttributeMap.fromAttributeType(a.getType());
            if (type == null) {
                _logger.warn((Object)("Attribute " + a.getLocalName() + "'s type is not supported by Terralib (" + a.getType().getBinding() + "). It was changed to String"));
                type = TypeAttributeMap.TA_STRING;
            }
            AttributeDescriptor attribute = TerralibAttributeHelper.buildType(name, type, a.getType().isIdentified(), a.isNillable(), a.getMaxOccurs(), a.getType().getRestrictions());
            builder.add(attribute);
            ++attrIndex;
        }
        if (featureType.getGeometryDescriptor() != null) {
            builder.setDefaultGeometry(featureType.getGeometryDescriptor().getLocalName());
        }
        SimpleFeatureType newType = builder.buildFeatureType();
        newType.getUserData().putAll(featureType.getUserData());
        return newType;
    }

    private String fixAttributeName(String attrName, int attrIndex) {
        for (String reservedName : TerralibDataStore.getReservedNames()) {
            if (!reservedName.equalsIgnoreCase(attrName)) continue;
            attrName = attrName + "_";
        }
        for (String illegalWord : TerralibDataStore.getIllegalWords()) {
            if (!attrName.contains(illegalWord)) continue;
            attrName = attrName.replace(illegalWord, "");
        }
        if (attrName.equals("")) {
            attrName = "field" + (attrIndex + 1);
        }
        return attrName;
    }

    public int getAttributeCount() {
        return this._targetFeatureType.getAttributeCount();
    }

    public List<AttributeDescriptor> getAttributeDescriptors() {
        return this._targetFeatureType.getAttributeDescriptors();
    }

    public AttributeDescriptor getDescriptor(String name) {
        return this._targetFeatureType.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(Name name) {
        return this._targetFeatureType.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(int index) throws IndexOutOfBoundsException {
        return this._targetFeatureType.getDescriptor(index);
    }

    public AttributeType getType(String name) {
        return this._targetFeatureType.getType(name);
    }

    public AttributeType getType(Name name) {
        return this._targetFeatureType.getType(name);
    }

    public AttributeType getType(int index) throws IndexOutOfBoundsException {
        return this._targetFeatureType.getType(index);
    }

    public String getTypeName() {
        return this._targetFeatureType.getTypeName();
    }

    public List<AttributeType> getTypes() {
        return this._targetFeatureType.getTypes();
    }

    public int indexOf(String name) {
        return this._targetFeatureType.indexOf(name);
    }

    public int indexOf(Name name) {
        return this._targetFeatureType.indexOf(name);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this._targetFeatureType.getCoordinateReferenceSystem();
    }

    public GeometryDescriptor getGeometryDescriptor() {
        return this._targetFeatureType.getGeometryDescriptor();
    }

    public boolean isIdentified() {
        return this._targetFeatureType.isIdentified();
    }

    public Class<Collection<Property>> getBinding() {
        return this._targetFeatureType.getBinding();
    }

    public Collection<PropertyDescriptor> getDescriptors() {
        return this._targetFeatureType.getDescriptors();
    }

    public boolean isInline() {
        return this._targetFeatureType.isInline();
    }

    public AttributeType getSuper() {
        return this._targetFeatureType.getSuper();
    }

    public InternationalString getDescription() {
        return this._targetFeatureType.getDescription();
    }

    public Name getName() {
        return this._targetFeatureType.getName();
    }

    public List<Filter> getRestrictions() {
        return this._targetFeatureType.getRestrictions();
    }

    public Map<Object, Object> getUserData() {
        return this._targetFeatureType.getUserData();
    }

    public boolean isAbstract() {
        return this._targetFeatureType.isAbstract();
    }
}

