/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;

public class GeometryBuilder {
    static GeometryFactory _defaultGeometryFactory = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    static LiteCoordinateSequenceFactory _sequenceFactory = new LiteCoordinateSequenceFactory();

    static double[] getPolygonExternalRing(Polygon polygon) {
        LineString lineString = polygon.getExteriorRing();
        return GeometryBuilder.getLineVertices(lineString);
    }

    public static double[] getLineVertices(LineString lineString) {
        Coordinate[] coordinates = lineString.getCoordinates();
        double[] vertices = new double[coordinates.length * 2];
        int index = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate currentCoord = coordinates[i];
            vertices[index] = currentCoord.x;
            vertices[index + 1] = currentCoord.y;
            index += 2;
        }
        return vertices;
    }

    public static LineString buildLineString(double[] vertices) {
        Coordinate[] coordinates = new Coordinate[vertices.length / 2];
        int index = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate coord;
            coordinates[i] = coord = new Coordinate(vertices[index], vertices[index + 1]);
            index += 2;
        }
        return _defaultGeometryFactory.createLineString(coordinates);
    }

    public static LinearRing buildLinearRing(double[] vertices) {
        CoordinateSequence coordinateSequence = _sequenceFactory.create(vertices);
        return _defaultGeometryFactory.createLinearRing(coordinateSequence);
    }
}

