/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.swig;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.swig.CoreJNI;
import org.geotools.data.terralib.swig.SWIGTYPE_p_TeDatabase;
import org.geotools.data.terralib.swig.SWIGTYPE_p_TeDatabasePortal;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptorVector;

public class DatabasePortal {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private static final Logger _logger = Logger.getLogger(DatabasePortal.class);

    protected DatabasePortal(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DatabasePortal obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void setToFreeNativeTarget(boolean isToFreenativeTarget) {
        this.swigCMemOwn = isToFreenativeTarget;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            CoreJNI.delete_DatabasePortal(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected DatabasePortal(SWIGTYPE_p_TeDatabasePortal target, SWIGTYPE_p_TeDatabase database) {
        this(CoreJNI.new_DatabasePortal(SWIGTYPE_p_TeDatabasePortal.getCPtr(target), SWIGTYPE_p_TeDatabase.getCPtr(database)), true);
    }

    public boolean query(String query) {
        return CoreJNI.DatabasePortal_query(this.swigCPtr, this, query);
    }

    public String getString(int i) {
        return CoreJNI.DatabasePortal_getString__SWIG_0(this.swigCPtr, this, i);
    }

    public String getString(String fieldName) {
        return CoreJNI.DatabasePortal_getString__SWIG_1(this.swigCPtr, this, fieldName);
    }

    public double getDouble(int i) {
        return CoreJNI.DatabasePortal_getDouble__SWIG_0(this.swigCPtr, this, i);
    }

    public double getDouble(String fieldName) {
        return CoreJNI.DatabasePortal_getDouble__SWIG_1(this.swigCPtr, this, fieldName);
    }

    public int getInt(int i) {
        return CoreJNI.DatabasePortal_getInt__SWIG_0(this.swigCPtr, this, i);
    }

    public int getInt(String fieldName) {
        return CoreJNI.DatabasePortal_getInt__SWIG_1(this.swigCPtr, this, fieldName);
    }

    public boolean getBool(String fieldName) {
        return CoreJNI.DatabasePortal_getBool__SWIG_0(this.swigCPtr, this, fieldName);
    }

    public boolean getBool(int i) {
        return CoreJNI.DatabasePortal_getBool__SWIG_1(this.swigCPtr, this, i);
    }

    public String getDate(int i) {
        return CoreJNI.DatabasePortal_getDate__SWIG_0(this.swigCPtr, this, i);
    }

    public String getDate(String fieldName) {
        return CoreJNI.DatabasePortal_getDate__SWIG_1(this.swigCPtr, this, fieldName);
    }

    public int getColumnIndex(String fieldName) {
        return CoreJNI.DatabasePortal_getColumnIndex(this.swigCPtr, this, fieldName);
    }

    public String getColumnName(int i) {
        return CoreJNI.DatabasePortal_getColumnName(this.swigCPtr, this, i);
    }

    public void freeResult() {
        CoreJNI.DatabasePortal_freeResult(this.swigCPtr, this);
    }

    public TerralibAttributeDescriptorVector getFields() {
        return new TerralibAttributeDescriptorVector(CoreJNI.DatabasePortal_getFields(this.swigCPtr, this), true);
    }

    public int getNumFields() {
        return CoreJNI.DatabasePortal_getNumFields(this.swigCPtr, this);
    }

    public int getNumRows() {
        return CoreJNI.DatabasePortal_getNumRows(this.swigCPtr, this);
    }

    public MultiPoint fetchPoint() throws IOException {
        return CoreJNI.DatabasePortal_fetchPoint(this.swigCPtr, this);
    }

    public MultiPolygon fetchPolygon() throws IOException {
        return CoreJNI.DatabasePortal_fetchPolygon(this.swigCPtr, this);
    }

    public MultiLineString fetchLine() throws IOException {
        return CoreJNI.DatabasePortal_fetchLine(this.swigCPtr, this);
    }

    public boolean hasNext() {
        return CoreJNI.DatabasePortal_hasNext(this.swigCPtr, this);
    }

    public String getErrorMessage() {
        return CoreJNI.DatabasePortal_getErrorMessage(this.swigCPtr, this);
    }

    public boolean isClosed() {
        return CoreJNI.DatabasePortal_isClosed(this.swigCPtr, this);
    }
}

