/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.util;

import java.util.List;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;

public class TerralibAttributeHelper {
    public static AttributeDescriptor buildType(String name, TypeAttributeMap binding, boolean primaryKey, boolean nullable, int maxOccurs) {
        return TerralibAttributeHelper.buildType(name, binding, primaryKey, nullable, maxOccurs, null);
    }

    public static AttributeDescriptor buildType(String name, TypeAttributeMap binding, boolean primaryKey, boolean nullable, int maxOccurs, List<Filter> restrictions) {
        AttributeTypeBuilder typeBuilder = new AttributeTypeBuilder();
        typeBuilder.setBinding(binding.getBindingClass());
        typeBuilder.setName(name);
        typeBuilder.setIdentifiable(primaryKey);
        typeBuilder.setNillable(nullable);
        typeBuilder.setLength(maxOccurs);
        typeBuilder.setMaxOccurs(maxOccurs);
        if (restrictions != null) {
            for (Filter filter : restrictions) {
                typeBuilder.addRestriction(filter);
            }
        }
        AttributeType attribute = typeBuilder.buildType();
        AttributeDescriptor attrDescriptor = typeBuilder.buildDescriptor(name, attribute);
        return attrDescriptor;
    }
}

