/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.util.thread;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.util.thread.TerralibWatchdogTask;

public class Watchdog
extends TimerTask {
    private Map<String, TerralibWatchdogTask> _tasks = new HashMap<String, TerralibWatchdogTask>();
    private Map<String, Long> _timers = new HashMap<String, Long>();
    private long _baseStepTimeMilliseconds;
    private static Logger _logger = Logger.getLogger(Watchdog.class);

    public Watchdog(long watchdogCheckStepMilliseconds) {
        this._baseStepTimeMilliseconds = watchdogCheckStepMilliseconds;
    }

    public synchronized void add(String id, long threadId, StackTraceElement[] lockedMethod, long lockerThreadID, StackTraceElement[] lockerMethod, long time) {
        TerralibWatchdogTask task = new TerralibWatchdogTask(id, threadId, lockedMethod, lockerThreadID, lockerMethod);
        this._tasks.put(id, task);
        this._timers.put(id, time / this._baseStepTimeMilliseconds);
    }

    public synchronized void remove(String id) {
        this._tasks.remove(id);
        this._timers.remove(id);
    }

    @Override
    public synchronized void run() {
        HashSet<String> finished = new HashSet<String>();
        for (Map.Entry<String, TerralibWatchdogTask> entry : this._tasks.entrySet()) {
            TerralibWatchdogTask task = entry.getValue();
            long time = this._timers.get(task.getId());
            if (time == 0L) {
                task.run();
                finished.add(entry.getKey());
                continue;
            }
            this._timers.put(entry.getKey(), time - 1L);
        }
        for (String threadId : finished) {
            this._tasks.remove(threadId);
            this._timers.remove(threadId);
        }
    }
}

