/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.vpf.ColumnPair;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FCode;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature>,
FCode {
    private boolean hasNext = true;
    private boolean nextCalled = true;
    private SimpleFeature currentFeature = null;
    private final VPFFeatureType featureType;

    public VPFFeatureReader(VPFFeatureType type) {
        this.featureType = type;
    }

    public void close() throws IOException {
        this.reset();
    }

    private Map generateFileRowMap(VPFFile file, SimpleFeature row) throws IOException {
        Object tileFileName = null;
        HashMap<VPFFile, SimpleFeature> rows = new HashMap<VPFFile, SimpleFeature>();
        rows.put(file, row);
        for (ColumnPair columnPair : this.featureType.getFeatureClass().getJoinList()) {
            VPFFile primaryFile = this.getVPFFile(columnPair.column1);
            VPFFile joinFile = null;
            joinFile = this.getVPFFile(columnPair.column2);
            if (rows.containsKey(joinFile) || !rows.containsKey(primaryFile)) continue;
            SimpleFeature joinRow = (SimpleFeature)rows.get(primaryFile);
            try {
                int joinID = Integer.parseInt(joinRow.getAttribute(columnPair.column1.getLocalName()).toString());
                rows.put(joinFile, this.getVPFFile(columnPair.column2).getRowFromId(columnPair.column2.getLocalName(), joinID));
            }
            catch (NullPointerException exc) {
                rows.put(joinFile, null);
            }
            catch (IllegalAttributeException exc) {
                exc.printStackTrace();
                rows.put(joinFile, null);
            }
        }
        return rows;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        if (this.nextCalled) {
            while (this.readNext()) {
            }
            this.nextCalled = false;
        }
        return this.hasNext;
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        this.nextCalled = true;
        return this.currentFeature;
    }

    private boolean readNext() throws IOException {
        boolean result = true;
        VPFFile file = (VPFFile)this.featureType.getFeatureClass().getFileList().get(0);
        this.hasNext = false;
        SimpleFeature row = null;
        try {
            if (file.hasNext()) {
                row = file.readFeature();
            }
        }
        catch (IOException exc1) {
            exc1.printStackTrace();
        }
        catch (IllegalAttributeException exc1) {
            exc1.printStackTrace();
        }
        if (row == null) {
            this.hasNext = false;
            result = false;
        } else if (this.featureType.getFaccCode() != null) {
            try {
                Object temp = null;
                for (int i = 0; temp == null && i < ALLOWED_FCODE_ATTRIBUTES.length; ++i) {
                    temp = row.getAttribute(ALLOWED_FCODE_ATTRIBUTES[i]);
                }
                String faccCode = temp.toString().trim();
                if (this.featureType.getFaccCode().equals(faccCode)) {
                    this.retrieveObject(file, row);
                    this.hasNext = true;
                    result = false;
                }
            }
            catch (RuntimeException exc) {
                // empty catch block
            }
        }
        return result;
    }

    private void retrieveObject(VPFFile file, SimpleFeature row) throws IOException {
        VPFFile secondFile = null;
        VPFColumn column = null;
        Map rows = this.generateFileRowMap(file, row);
        List attributes = this.featureType.getFeatureClass().getAttributeDescriptors();
        Object[] values = new Object[this.featureType.getAttributeCount()];
        Object value = null;
        String featureId = null;
        for (int inx = 0; inx < attributes.size(); ++inx) {
            if (!((AttributeDescriptor)attributes.get(inx)).getLocalName().equals("id")) continue;
            value = row.getAttribute(inx);
            if (value == null) break;
            featureId = value.toString();
            break;
        }
        try {
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, (Object[])values, featureId);
        }
        catch (IllegalAttributeException exc) {
            exc.printStackTrace();
        }
        for (int inx = 0; inx < attributes.size(); ++inx) {
            try {
                if (((AttributeDescriptor)attributes.get(inx)).getLocalName().equals("annotation_attribute_name")) {
                    try {
                        this.currentFeature.setAttribute(inx, (Object)"nam");
                    }
                    catch (IllegalAttributeException exc) {
                        exc.printStackTrace();
                    }
                    continue;
                }
                column = (VPFColumn)attributes.get(inx);
                value = null;
                secondFile = this.getVPFFile(column);
                SimpleFeature tempRow = (SimpleFeature)rows.get(secondFile);
                if (tempRow != null) {
                    value = tempRow.getAttribute(column.getLocalName());
                    if (column.isAttemptLookup()) {
                        try {
                            String featureClassName = this.getVPFFile(column).getFileName();
                            String intVdtFileName = this.featureType.getFeatureClass().getDirectoryName().concat(File.separator).concat("int.vdt");
                            VPFFile intVdtFile = VPFFileFactory.getInstance().getFile(intVdtFileName);
                            for (SimpleFeature intVdtRow : intVdtFile.readAllRows()) {
                                if (!intVdtRow.getAttribute("table").toString().trim().equals(featureClassName) || Short.parseShort(intVdtRow.getAttribute("value").toString()) != Short.parseShort(value.toString()) || !intVdtRow.getAttribute("attribute").toString().trim().equals(column.getLocalName())) continue;
                                value = intVdtRow.getAttribute("description").toString().trim();
                                break;
                            }
                        }
                        catch (IOException exc) {
                        }
                        catch (RuntimeException exc) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.currentFeature.setAttribute(inx, value);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    exc.printStackTrace();
                }
                catch (IllegalAttributeException exc) {
                    exc.printStackTrace();
                }
                continue;
            }
            catch (ClassCastException exc2) {
                try {
                    this.featureType.getFeatureClass().getGeometryFactory().createGeometry(this.featureType, this.currentFeature);
                    continue;
                }
                catch (IllegalAttributeException exc) {
                    exc.printStackTrace();
                    continue;
                }
                catch (SQLException exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    private VPFFile getVPFFile(AttributeDescriptor column) {
        VPFFile result = null;
        for (VPFFile temp : this.featureType.getFeatureClass().getFileList()) {
            if (temp == null || temp.indexOf(column.getName()) < 0) continue;
            result = temp;
            break;
        }
        return result;
    }

    public void reset() {
        VPFFile file = (VPFFile)this.featureType.getFeatureClass().getFileList().get(0);
        file.reset();
        VPFFileFactory.getInstance().reset();
    }
}

