/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import org.geotools.data.vpf.exc.VPFDataFormatException;

public class TripletId
extends Number {
    private byte[] rawData = null;

    public TripletId(byte[] data) {
        this.rawData = data;
    }

    public String toString() {
        String result = new String();
        try {
            if (this.getIdLength() > 0) {
                result = new Integer(this.getId()).toString();
            }
            if (this.getTileIdLength() > 0) {
                result = result.concat("%").concat(new Integer(this.getTileId()).toString()).trim();
            }
            if (this.getNextIdLength() > 0) {
                result = result.concat("%").concat(new Integer(this.getNextId()).toString()).trim();
            }
        }
        catch (RuntimeException exp) {
            throw new VPFDataFormatException("This triplet is invalid.", exp);
        }
        return result;
    }

    private int getIdLength() {
        return this.rawData[0] >> 6 & 3;
    }

    private int getTileIdLength() {
        return this.rawData[0] >> 4 & 3;
    }

    private int getNextIdLength() {
        return this.rawData[0] >> 2 & 3;
    }

    public int getId() {
        int result = 0;
        int length = this.getIdLength();
        if (length > 0) {
            try {
                int inx = 0;
                while (inx < length) {
                    int piece = this.rawData[inx + 1];
                    if (piece < 0) {
                        piece += 256;
                    }
                    result += piece << 8 * inx;
                    ++inx;
                }
            }
            catch (RuntimeException exp) {
                exp.printStackTrace();
                result = 0;
            }
        }
        return result;
    }

    public int getTileId() {
        int result = 0;
        int length = this.getTileIdLength();
        if (length > 0) {
            int rowIdLength = this.getIdLength();
            try {
                int inx = 0;
                while (inx < length) {
                    int piece = this.rawData[inx + rowIdLength + 1];
                    if (piece < 0) {
                        piece += 254;
                    }
                    result += piece << 8 * inx;
                    ++inx;
                }
            }
            catch (RuntimeException exp) {
                exp.printStackTrace();
                result = 0;
            }
        }
        return result;
    }

    public int getNextId() {
        int result = 0;
        int length = this.getTileIdLength();
        if (length > 0) {
            int prevLength = this.getIdLength() + this.getTileIdLength();
            try {
                int inx = 0;
                while (inx < length) {
                    int piece = this.rawData[inx + prevLength + 1];
                    if (piece < 0) {
                        piece += 254;
                    }
                    result += piece << 8 * inx;
                    ++inx;
                }
            }
            catch (RuntimeException exp) {
                exp.printStackTrace();
                result = 0;
            }
        }
        return result;
    }

    public static int calculateDataSize(byte definition) {
        int[] pieces = new int[]{definition >> 2 & 3, definition >> 4 & 3, definition >> 6 & 3};
        int size = 0;
        int i = 0;
        while (i < pieces.length) {
            switch (pieces[i]) {
                case 0: {
                    break;
                }
                case 1: {
                    ++size;
                    break;
                }
                case 2: {
                    size += 2;
                    break;
                }
                case 3: {
                    size += 4;
                    break;
                }
                default: {
                    System.out.println("Tripled id size decoding error");
                    System.out.println("tripled definition: " + definition);
                    System.out.println("piece 0: " + pieces[0]);
                    System.out.println("piece 1: " + pieces[1]);
                    System.out.println("piece 2: " + pieces[2]);
                }
            }
            ++i;
        }
        return size;
    }

    public double doubleValue() {
        return new Integer(this.getId()).doubleValue();
    }

    public float floatValue() {
        return new Integer(this.getId()).floatValue();
    }

    public int intValue() {
        return this.getId();
    }

    public long longValue() {
        return new Integer(this.getId()).longValue();
    }

    public byte byteValue() {
        return new Integer(this.getId()).byteValue();
    }

    public short shortValue() {
        return new Integer(this.getId()).shortValue();
    }
}

