/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class VPFDate {
    private SimpleDateFormat sdf = null;
    private byte[] dateBin = null;

    public VPFDate(byte[] date) {
        this.dateBin = (byte[])date.clone();
        this.initialize();
    }

    public VPFDate(String date) {
        this.dateBin = new byte[date.length()];
        int i = 0;
        while (i < date.length()) {
            this.dateBin[i] = (byte)date.charAt(i);
            ++i;
        }
        this.initialize();
    }

    private void initialize() {
        int i = 0;
        while (i < this.dateBin.length) {
            if ((char)this.dateBin[i] == ' ') {
                this.dateBin[i] = 48;
            }
            ++i;
        }
        this.sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer sb = new StringBuffer();
        int i2 = 15;
        while (i2 < this.dateBin.length) {
            char cr = (char)this.dateBin[i2];
            if (i2 == 18) {
                sb.append(':');
            }
            sb.append(cr);
            ++i2;
        }
        this.sdf.setTimeZone(TimeZone.getTimeZone(sb.toString()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.dateBin.length);
        int i = 0;
        while (i < this.dateBin.length) {
            sb.append((char)this.dateBin[i]);
            ++i;
        }
        return sb.toString();
    }

    public Date getDate() {
        try {
            return this.sdf.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Calendar getCalendar() {
        try {
            this.sdf.parse(this.toString());
            return this.sdf.getCalendar();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

