/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.ows.FeatureSetDescription;
import org.geotools.data.wfs.v1_0_0.StrictWFSStrategy;
import org.geotools.data.wfs.v1_0_0.WFSStrategy;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapServerWFSStrategy
extends StrictWFSStrategy
implements WFSStrategy {
    public MapServerWFSStrategy(WFS_1_0_0_DataStore store) {
        super(store);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(Transaction transaction, Query query) throws IOException {
        return new MapServerWFSFeatureReader(transaction, query, COMPLIANCE_LEVEL);
    }

    protected class MapServerWFSFeatureReader
    extends StrictWFSStrategy.StrictFeatureReader {
        public MapServerWFSFeatureReader(Transaction transaction, Query query, Integer level) throws IOException {
            super(MapServerWFSStrategy.this, transaction, query, level);
        }

        protected void init(Transaction transaction, Query query, Integer level) throws IOException {
            Query query2;
            block6: {
                Filter filter = query.getFilter();
                if (filter == Filter.INCLUDE) {
                    FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
                    try {
                        SimpleFeatureType schema = MapServerWFSStrategy.this.store.getSchema(query.getTypeName());
                        String attName = schema.getGeometryDescriptor().getLocalName();
                        List<FeatureSetDescription> fts = MapServerWFSStrategy.this.store.capabilities.getFeatureTypes();
                        Iterator<FeatureSetDescription> i = fts.iterator();
                        String desiredType = query.getTypeName().substring(query.getTypeName().indexOf(":") + 1);
                        Envelope bbox = null;
                        while (i.hasNext()) {
                            FeatureSetDescription fsd = i.next();
                            String fsdName = fsd.getName() == null ? null : fsd.getName().substring(fsd.getName().indexOf(":") + 1);
                            if (!desiredType.equals(fsdName)) continue;
                            bbox = fsd.getLatLongBoundingBox();
                        }
                        if (bbox == null) {
                            query2 = query;
                            break block6;
                        }
                        BBOX newFilter = fac.bbox(attName, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), "EPSG:4326");
                        query2 = new DefaultQuery(query);
                        query2.setFilter((Filter)newFilter);
                    }
                    catch (IllegalFilterException e) {
                        query2 = query;
                    }
                } else {
                    query2 = query;
                }
            }
            super.init(transaction, query2, level);
        }
    }
}

