/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.io.IOException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.ows.FeatureSetDescription;
import org.geotools.data.ows.WFSCapabilities;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.data.wfs.v1_0_0.WFSStrategy;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.Filters;
import org.geotools.filter.visitor.WFSBBoxFilterVisitor;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NonStrictWFSStrategy
implements WFSStrategy {
    protected WFS_1_0_0_DataStore store;

    public NonStrictWFSStrategy(WFS_1_0_0_DataStore store) {
        this.store = store;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query2, Transaction transaction) throws IOException {
        DefaultQuery query = new DefaultQuery(query2);
        Filter processedFilter = this.store.processFilter(query.getFilter());
        query.setFilter(processedFilter);
        Filter[] filters = this.store.splitFilters((Query)query, transaction);
        Filter serverFilter = filters[0];
        Filter postFilter = filters[1];
        CoordinateReferenceSystem dataCRS = this.correctFilterForServer(query.getTypeName(), serverFilter);
        query.setFilter(serverFilter);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.createFeatureReader(transaction, (Query)query);
        if (reader.hasNext()) {
            if (reader.getFeatureType() != null) {
                reader = this.wrapWithFilteringFeatureReader(postFilter, reader, processedFilter);
                reader = this.applyReprojectionDecorator(reader, (Query)query, dataCRS);
                return reader;
            }
            throw new IOException("There are features but no feature type ... odd");
        }
        return new EmptyFeatureReader((FeatureType)this.store.getSchema(query.getTypeName()));
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> wrapWithFilteringFeatureReader(Filter postFilter, FeatureReader<SimpleFeatureType, SimpleFeature> reader, Filter processedFilter) {
        if (!postFilter.equals(Filter.INCLUDE)) {
            return new FilteringFeatureReader(reader, postFilter);
        }
        return reader;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> createFeatureReader(Transaction transaction, Query query) throws IOException {
        Data data;
        if (this.store.preferredProtocol == HttpMethod.POST) {
            data = this.createFeatureReaderPOST(query, transaction);
            if (data.reader == null) {
                data = this.createFeatureReaderGET(query, transaction);
            }
        } else {
            data = this.createFeatureReaderGET(query, transaction);
            if (data.reader == null) {
                data = this.createFeatureReaderPOST(query, transaction);
            }
        }
        if (data.reader == null && data.saxException != null) {
            throw (IOException)new IOException(data.saxException.toString()).initCause(data.saxException);
        }
        if (data.reader == null && data.ioException != null) {
            throw data.ioException;
        }
        return data.reader;
    }

    protected Data createFeatureReaderPOST(Query query, Transaction transaction) {
        Data data = new Data();
        try {
            data.reader = this.store.getFeatureReaderPost(query, transaction);
            if (data.reader != null) {
                data.reader.hasNext();
            }
        }
        catch (SAXException e) {
            data.reader = null;
            WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
            data.saxException = e;
        }
        catch (IOException e) {
            data.reader = null;
            WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
            data.ioException = e;
        }
        return data;
    }

    protected Data createFeatureReaderGET(Query query, Transaction transaction) {
        Data data = new Data();
        try {
            data.reader = this.store.getFeatureReaderGet(query, transaction);
            if (data.reader != null) {
                data.reader.hasNext();
            }
        }
        catch (SAXException e) {
            data.reader = null;
            WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
            data.saxException = e;
        }
        catch (IOException e) {
            data.reader = null;
            WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
            data.ioException = e;
        }
        return data;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> applyReprojectionDecorator(FeatureReader<SimpleFeatureType, SimpleFeature> reader, Query query, CoordinateReferenceSystem dataCRS) {
        ForceCoordinateSystemFeatureReader tmp = reader;
        if (query.getCoordinateSystem() != null && !query.getCoordinateSystem().equals(((SimpleFeatureType)reader.getFeatureType()).getCoordinateReferenceSystem())) {
            try {
                reader = new ForceCoordinateSystemFeatureReader(reader, query.getCoordinateSystem());
            }
            catch (SchemaException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
                reader = tmp;
            }
        } else if (((SimpleFeatureType)reader.getFeatureType()).getGeometryDescriptor() != null && dataCRS != null && ((SimpleFeatureType)reader.getFeatureType()).getCoordinateReferenceSystem() == null) {
            try {
                reader = new ForceCoordinateSystemFeatureReader((FeatureReader)reader, dataCRS);
            }
            catch (SchemaException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
                reader = tmp;
            }
        }
        return reader;
    }

    protected boolean isStrict() {
        return false;
    }

    protected CoordinateReferenceSystem correctFilterForServer(String typeName, Filter serverFilter) {
        FeatureSetDescription fsd = WFSCapabilities.getFeatureSetDescription(this.store.capabilities, typeName);
        CoordinateReferenceSystem dataCRS = null;
        if (fsd.getSRS() != null) {
            try {
                dataCRS = CRS.decode((String)fsd.getSRS());
            }
            catch (FactoryException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
            }
            catch (MismatchedDimensionException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.getMessage());
            }
        }
        WFSBBoxFilterVisitor visitor = new WFSBBoxFilterVisitor(null);
        Filters.accept((Filter)serverFilter, (FilterVisitor)visitor);
        return dataCRS;
    }

    protected class Data {
        IOException ioException;
        SAXException saxException;
        FeatureReader<SimpleFeatureType, SimpleFeature> reader;

        protected Data() {
        }
    }
}

